@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.UserPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM policy attached to a user.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lb = new aws.iam.User("lb", {
 *     name: "loadbalancer",
 *     path: "/system/",
 * });
 * const lbRo = new aws.iam.UserPolicy("lb_ro", {
 *     name: "test",
 *     user: lb.name,
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * const lbAccessKey = new aws.iam.AccessKey("lb", {user: lb.name});
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * lb = aws.iam.User("lb",
 *     name="loadbalancer",
 *     path="/system/")
 * lb_ro = aws.iam.UserPolicy("lb_ro",
 *     name="test",
 *     user=lb.name,
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * lb_access_key = aws.iam.AccessKey("lb", user=lb.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lb = new Aws.Iam.User("lb", new()
 *     {
 *         Name = "loadbalancer",
 *         Path = "/system/",
 *     });
 *     var lbRo = new Aws.Iam.UserPolicy("lb_ro", new()
 *     {
 *         Name = "test",
 *         User = lb.Name,
 *         Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 *     var lbAccessKey = new Aws.Iam.AccessKey("lb", new()
 *     {
 *         User = lb.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lb, err := iam.NewUser(ctx, "lb", &iam.UserArgs{
 * 			Name: pulumi.String("loadbalancer"),
 * 			Path: pulumi.String("/system/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = iam.NewUserPolicy(ctx, "lb_ro", &iam.UserPolicyArgs{
 * 			Name:   pulumi.String("test"),
 * 			User:   lb.Name,
 * 			Policy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewAccessKey(ctx, "lb", &iam.AccessKeyArgs{
 * 			User: lb.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.UserPolicy;
 * import com.pulumi.aws.iam.UserPolicyArgs;
 * import com.pulumi.aws.iam.AccessKey;
 * import com.pulumi.aws.iam.AccessKeyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new User("lb", UserArgs.builder()
 *             .name("loadbalancer")
 *             .path("/system/")
 *             .build());
 *         var lbRo = new UserPolicy("lbRo", UserPolicyArgs.builder()
 *             .name("test")
 *             .user(lb.name())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var lbAccessKey = new AccessKey("lbAccessKey", AccessKeyArgs.builder()
 *             .user(lb.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lbRo:
 *     type: aws:iam:UserPolicy
 *     name: lb_ro
 *     properties:
 *       name: test
 *       user: ${lb.name}
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 *   lb:
 *     type: aws:iam:User
 *     properties:
 *       name: loadbalancer
 *       path: /system/
 *   lbAccessKey:
 *     type: aws:iam:AccessKey
 *     name: lb
 *     properties:
 *       user: ${lb.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM User Policies using the `user_name:user_policy_name`. For example:
 * ```sh
 * $ pulumi import aws:iam/userPolicy:UserPolicy mypolicy user_of_mypolicy_name:mypolicy_name
 * ```
 * @property name The name of the policy. If omitted, the provider will assign a random, unique name.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property policy The policy document. This is a JSON formatted string.
 * @property user IAM user to which to attach this policy.
 */
public data class UserPolicyArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val user: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.UserPolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.UserPolicyArgs =
        com.pulumi.aws.iam.UserPolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .user(user?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPolicyArgs].
 */
@PulumiTagMarker
public class UserPolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    private var user: Output<String>? = null

    /**
     * @param value The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("jgntayseghjxhpwq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("lxbkbklaoiqorjkm")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("mnlosisapgpoyhlq")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value IAM user to which to attach this policy.
     */
    @JvmName("yylxjbiagvxrbhmc")
    public suspend fun user(`value`: Output<String>) {
        this.user = value
    }

    /**
     * @param value The name of the policy. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("sexuefvxstecwqdk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ukwdvpohpnstbuhx")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The policy document. This is a JSON formatted string.
     */
    @JvmName("melkxmbckaadvyqc")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value IAM user to which to attach this policy.
     */
    @JvmName("dgjuyucksvwqdvaj")
    public suspend fun user(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.user = mapped
    }

    internal fun build(): UserPolicyArgs = UserPolicyArgs(
        name = name,
        namePrefix = namePrefix,
        policy = policy,
        user = user,
    )
}
