@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserPolicyAttachment].
 */
@PulumiTagMarker
public class UserPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserPolicyAttachmentArgs = UserPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = UserPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserPolicyAttachment {
        val builtJavaResource = com.pulumi.aws.iam.UserPolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserPolicyAttachment(builtJavaResource)
    }
}

/**
 * Attaches a Managed IAM Policy to an IAM user
 * > **NOTE:** The usage of this resource conflicts with the `aws.iam.PolicyAttachment` resource and will permanently show a difference if both are defined.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const user = new aws.iam.User("user", {name: "test-user"});
 * const policy = new aws.iam.Policy("policy", {
 *     name: "test-policy",
 *     description: "A test policy",
 *     policy: "{ ... policy JSON ... }",
 * });
 * const test_attach = new aws.iam.UserPolicyAttachment("test-attach", {
 *     user: user.name,
 *     policyArn: policy.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * user = aws.iam.User("user", name="test-user")
 * policy = aws.iam.Policy("policy",
 *     name="test-policy",
 *     description="A test policy",
 *     policy="{ ... policy JSON ... }")
 * test_attach = aws.iam.UserPolicyAttachment("test-attach",
 *     user=user.name,
 *     policy_arn=policy.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new Aws.Iam.User("user", new()
 *     {
 *         Name = "test-user",
 *     });
 *     var policy = new Aws.Iam.Policy("policy", new()
 *     {
 *         Name = "test-policy",
 *         Description = "A test policy",
 *         PolicyDocument = "{ ... policy JSON ... }",
 *     });
 *     var test_attach = new Aws.Iam.UserPolicyAttachment("test-attach", new()
 *     {
 *         User = user.Name,
 *         PolicyArn = policy.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		user, err := iam.NewUser(ctx, "user", &iam.UserArgs{
 * 			Name: pulumi.String("test-user"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy, err := iam.NewPolicy(ctx, "policy", &iam.PolicyArgs{
 * 			Name:        pulumi.String("test-policy"),
 * 			Description: pulumi.String("A test policy"),
 * 			Policy:      pulumi.Any("{ ... policy JSON ... }"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewUserPolicyAttachment(ctx, "test-attach", &iam.UserPolicyAttachmentArgs{
 * 			User:      user.Name,
 * 			PolicyArn: policy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.User;
 * import com.pulumi.aws.iam.UserArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.UserPolicyAttachment;
 * import com.pulumi.aws.iam.UserPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .name("test-user")
 *             .build());
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .name("test-policy")
 *             .description("A test policy")
 *             .policy("{ ... policy JSON ... }")
 *             .build());
 *         var test_attach = new UserPolicyAttachment("test-attach", UserPolicyAttachmentArgs.builder()
 *             .user(user.name())
 *             .policyArn(policy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   user:
 *     type: aws:iam:User
 *     properties:
 *       name: test-user
 *   policy:
 *     type: aws:iam:Policy
 *     properties:
 *       name: test-policy
 *       description: A test policy
 *       policy: '{ ... policy JSON ... }'
 *   test-attach:
 *     type: aws:iam:UserPolicyAttachment
 *     properties:
 *       user: ${user.name}
 *       policyArn: ${policy.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM user policy attachments using the user name and policy arn separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:iam/userPolicyAttachment:UserPolicyAttachment test-attach test-user/arn:aws:iam::xxxxxxxxxxxx:policy/test-policy
 * ```
 */
public class UserPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.iam.UserPolicyAttachment,
) : KotlinCustomResource(javaResource, UserPolicyAttachmentMapper) {
    /**
     * The ARN of the policy you want to apply
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * The user the policy should be applied to
     */
    public val user: Output<String>
        get() = javaResource.user().applyValue({ args0 -> args0 })
}

public object UserPolicyAttachmentMapper : ResourceMapper<UserPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.iam.UserPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): UserPolicyAttachment = UserPolicyAttachment(
        javaResource
            as com.pulumi.aws.iam.UserPolicyAttachment,
    )
}

/**
 * @see [UserPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserPolicyAttachment].
 */
public suspend fun userPolicyAttachment(
    name: String,
    block: suspend UserPolicyAttachmentResourceBuilder.() -> Unit,
): UserPolicyAttachment {
    val builder = UserPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userPolicyAttachment(name: String): UserPolicyAttachment {
    val builder = UserPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
