@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin

import com.pulumi.aws.iam.VirtualMfaDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IAM Virtual MFA Device.
 * > **Note:** All attributes will be stored in the raw state as plain-text.
 * > **Note:** A virtual MFA device cannot be directly associated with an IAM User from the provider.
 *   To associate the virtual MFA device with a user and enable it, use the code returned in either `base_32_string_seed` or `qr_code_png` to generate TOTP authentication codes.
 *   The authentication codes can then be used with the AWS CLI command [`aws iam enable-mfa-device`](https://docs&#46;aws&#46;amazon&#46;com/cli/latest/reference/iam/enable-mfa-device&#46;html) or the AWS API call [`EnableMFADevice`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html).
 * ## Example Usage
 * **Using certs on file:**
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.VirtualMfaDevice("example", {virtualMfaDeviceName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.VirtualMfaDevice("example", virtual_mfa_device_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.VirtualMfaDevice("example", new()
 *     {
 *         VirtualMfaDeviceName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.NewVirtualMfaDevice(ctx, "example", &iam.VirtualMfaDeviceArgs{
 * 			VirtualMfaDeviceName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.VirtualMfaDevice;
 * import com.pulumi.aws.iam.VirtualMfaDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VirtualMfaDevice("example", VirtualMfaDeviceArgs.builder()
 *             .virtualMfaDeviceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:VirtualMfaDevice
 *     properties:
 *       virtualMfaDeviceName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import IAM Virtual MFA Devices using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:iam/virtualMfaDevice:VirtualMfaDevice example arn:aws:iam::123456789012:mfa/example
 * ```
 * @property path The path for the virtual MFA device.
 * @property tags Map of resource tags for the virtual mfa device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualMfaDeviceName The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
 */
public data class VirtualMfaDeviceArgs(
    public val path: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMfaDeviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.VirtualMfaDeviceArgs> {
    override fun toJava(): com.pulumi.aws.iam.VirtualMfaDeviceArgs =
        com.pulumi.aws.iam.VirtualMfaDeviceArgs.builder()
            .path(path?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMfaDeviceName(virtualMfaDeviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMfaDeviceArgs].
 */
@PulumiTagMarker
public class VirtualMfaDeviceArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMfaDeviceName: Output<String>? = null

    /**
     * @param value The path for the virtual MFA device.
     */
    @JvmName("bejgeeboqhhpfpft")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Map of resource tags for the virtual mfa device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xdcsxdtvejxsolqa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
     */
    @JvmName("pykjighmnfoqsaiw")
    public suspend fun virtualMfaDeviceName(`value`: Output<String>) {
        this.virtualMfaDeviceName = value
    }

    /**
     * @param value The path for the virtual MFA device.
     */
    @JvmName("bdotmhoccdwfgqrx")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Map of resource tags for the virtual mfa device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bbjricyjcoxwyiin")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the virtual mfa device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkkvtinylfmnjwhm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
     */
    @JvmName("uhwyidkiawcojpfh")
    public suspend fun virtualMfaDeviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMfaDeviceName = mapped
    }

    internal fun build(): VirtualMfaDeviceArgs = VirtualMfaDeviceArgs(
        path = path,
        tags = tags,
        virtualMfaDeviceName = virtualMfaDeviceName,
    )
}
