@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetAccessKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessKeys.
 * @property user Name of the IAM user associated with the access keys.
 */
public data class GetAccessKeysPlainArgs(
    public val user: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetAccessKeysPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetAccessKeysPlainArgs =
        com.pulumi.aws.iam.inputs.GetAccessKeysPlainArgs.builder()
            .user(user.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessKeysPlainArgs].
 */
@PulumiTagMarker
public class GetAccessKeysPlainArgsBuilder internal constructor() {
    private var user: String? = null

    /**
     * @param value Name of the IAM user associated with the access keys.
     */
    @JvmName("bixelgxxxmnyeuqo")
    public suspend fun user(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.user = mapped
    }

    internal fun build(): GetAccessKeysPlainArgs = GetAccessKeysPlainArgs(
        user = user ?: throw PulumiNullFieldException("user"),
    )
}
