@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOpenIdConnectProvider.
 * @property arn ARN of the OpenID Connect provider.
 * @property tags Map of resource tags for the IAM OIDC provider.
 * @property url URL of the OpenID Connect provider.
 */
public data class GetOpenIdConnectProviderPlainArgs(
    public val arn: String? = null,
    public val tags: Map<String, String>? = null,
    public val url: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderPlainArgs =
        com.pulumi.aws.iam.inputs.GetOpenIdConnectProviderPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .url(url?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOpenIdConnectProviderPlainArgs].
 */
@PulumiTagMarker
public class GetOpenIdConnectProviderPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    private var url: String? = null

    /**
     * @param value ARN of the OpenID Connect provider.
     */
    @JvmName("atmhepyofyfnyrpm")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Map of resource tags for the IAM OIDC provider.
     */
    @JvmName("kexugtnlvvxggnfj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the IAM OIDC provider.
     */
    @JvmName("egklkmeegmmynmqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value URL of the OpenID Connect provider.
     */
    @JvmName("unqixcsotukuasun")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.url = mapped
    }

    internal fun build(): GetOpenIdConnectProviderPlainArgs = GetOpenIdConnectProviderPlainArgs(
        arn = arn,
        tags = tags,
        url = url,
    )
}
