@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPolicyDocument.
 * @property overrideJson
 * @property overridePolicyDocuments List of IAM policy documents that are merged together into the exported document. In merging, statements with non-blank `sid`s will override statements with the same `sid` from earlier documents in the list. Statements with non-blank `sid`s will also override statements with the same `sid` from `source_policy_documents`.  Non-overriding statements will be added to the exported document.
 * @property policyId ID for the policy document.
 * @property sourceJson
 * @property sourcePolicyDocuments List of IAM policy documents that are merged together into the exported document. Statements defined in `source_policy_documents` must have unique `sid`s. Statements with the same `sid` from `override_policy_documents` will override source statements.
 * @property statements Configuration block for a policy statement. Detailed below.
 * @property version IAM policy document version. Valid values are `2008-10-17` and `2012-10-17`. Defaults to `2012-10-17`. For more information, see the [AWS IAM User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_version.html).
 */
public data class GetPolicyDocumentPlainArgs(
    @Deprecated(
        message = """
  Not used
  """,
    )
    public val overrideJson: String? = null,
    public val overridePolicyDocuments: List<String>? = null,
    public val policyId: String? = null,
    @Deprecated(
        message = """
  Not used
  """,
    )
    public val sourceJson: String? = null,
    public val sourcePolicyDocuments: List<String>? = null,
    public val statements: List<GetPolicyDocumentStatement>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPolicyDocumentPlainArgs =
        com.pulumi.aws.iam.inputs.GetPolicyDocumentPlainArgs.builder()
            .overrideJson(overrideJson?.let({ args0 -> args0 }))
            .overridePolicyDocuments(overridePolicyDocuments?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .policyId(policyId?.let({ args0 -> args0 }))
            .sourceJson(sourceJson?.let({ args0 -> args0 }))
            .sourcePolicyDocuments(sourcePolicyDocuments?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .statements(
                statements?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDocumentPlainArgsBuilder internal constructor() {
    private var overrideJson: String? = null

    private var overridePolicyDocuments: List<String>? = null

    private var policyId: String? = null

    private var sourceJson: String? = null

    private var sourcePolicyDocuments: List<String>? = null

    private var statements: List<GetPolicyDocumentStatement>? = null

    private var version: String? = null

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Not used
  """,
    )
    @JvmName("qvuuiecvcndfebhu")
    public suspend fun overrideJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.overrideJson = mapped
    }

    /**
     * @param value List of IAM policy documents that are merged together into the exported document. In merging, statements with non-blank `sid`s will override statements with the same `sid` from earlier documents in the list. Statements with non-blank `sid`s will also override statements with the same `sid` from `source_policy_documents`.  Non-overriding statements will be added to the exported document.
     */
    @JvmName("jdkqbdfmxdktlnud")
    public suspend fun overridePolicyDocuments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.overridePolicyDocuments = mapped
    }

    /**
     * @param values List of IAM policy documents that are merged together into the exported document. In merging, statements with non-blank `sid`s will override statements with the same `sid` from earlier documents in the list. Statements with non-blank `sid`s will also override statements with the same `sid` from `source_policy_documents`.  Non-overriding statements will be added to the exported document.
     */
    @JvmName("sgxolnbgoisjkykq")
    public suspend fun overridePolicyDocuments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.overridePolicyDocuments = mapped
    }

    /**
     * @param value ID for the policy document.
     */
    @JvmName("ggkqqgqdmrvxecal")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.policyId = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Not used
  """,
    )
    @JvmName("captreavwssumkot")
    public suspend fun sourceJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceJson = mapped
    }

    /**
     * @param value List of IAM policy documents that are merged together into the exported document. Statements defined in `source_policy_documents` must have unique `sid`s. Statements with the same `sid` from `override_policy_documents` will override source statements.
     */
    @JvmName("bmgyopqesqiswcuj")
    public suspend fun sourcePolicyDocuments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourcePolicyDocuments = mapped
    }

    /**
     * @param values List of IAM policy documents that are merged together into the exported document. Statements defined in `source_policy_documents` must have unique `sid`s. Statements with the same `sid` from `override_policy_documents` will override source statements.
     */
    @JvmName("dddnvcbutrgkldbi")
    public suspend fun sourcePolicyDocuments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourcePolicyDocuments = mapped
    }

    /**
     * @param value Configuration block for a policy statement. Detailed below.
     */
    @JvmName("gctfjqkjiaqjgjew")
    public suspend fun statements(`value`: List<GetPolicyDocumentStatement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param argument Configuration block for a policy statement. Detailed below.
     */
    @JvmName("vkwxttwbkdfggwll")
    public suspend fun statements(argument: List<suspend GetPolicyDocumentStatementBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Configuration block for a policy statement. Detailed below.
     */
    @JvmName("jxluoxndjpwaeunc")
    public suspend fun statements(vararg argument: suspend GetPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPolicyDocumentStatementBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Configuration block for a policy statement. Detailed below.
     */
    @JvmName("vllqubbsfuuximum")
    public suspend fun statements(argument: suspend GetPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = listOf(GetPolicyDocumentStatementBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param values Configuration block for a policy statement. Detailed below.
     */
    @JvmName("nyyqdjqsnrjbnnhy")
    public suspend fun statements(vararg values: GetPolicyDocumentStatement) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param value IAM policy document version. Valid values are `2008-10-17` and `2012-10-17`. Defaults to `2012-10-17`. For more information, see the [AWS IAM User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_version.html).
     */
    @JvmName("ndtijrwsvxjviqjf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetPolicyDocumentPlainArgs = GetPolicyDocumentPlainArgs(
        overrideJson = overrideJson,
        overridePolicyDocuments = overridePolicyDocuments,
        policyId = policyId,
        sourceJson = sourceJson,
        sourcePolicyDocuments = sourcePolicyDocuments,
        statements = statements,
        version = version,
    )
}
