@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementCondition.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property test Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
 * @property values Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
 * @property variable Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
 */
public data class GetPolicyDocumentStatementCondition(
    public val test: String,
    public val values: List<String>,
    public val variable: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementCondition> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementCondition =
        com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementCondition.builder()
            .test(test.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .variable(variable.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentStatementCondition].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementConditionBuilder internal constructor() {
    private var test: String? = null

    private var values: List<String>? = null

    private var variable: String? = null

    /**
     * @param value Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
     */
    @JvmName("anoquerjfmweyqni")
    public suspend fun test(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.test = mapped
    }

    /**
     * @param value Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
     */
    @JvmName("bqenksqehhjjvjej")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
     */
    @JvmName("oytfgthtmewsqyav")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param value Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
     */
    @JvmName("yhhoponlpantksfc")
    public suspend fun variable(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variable = mapped
    }

    internal fun build(): GetPolicyDocumentStatementCondition = GetPolicyDocumentStatementCondition(
        test = test ?: throw PulumiNullFieldException("test"),
        values = values ?: throw PulumiNullFieldException("values"),
        variable = variable ?: throw PulumiNullFieldException("variable"),
    )
}
