@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementPrincipal.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property identifiers List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
 * @property type Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
 */
public data class GetPolicyDocumentStatementPrincipal(
    public val identifiers: List<String>,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementPrincipal> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementPrincipal =
        com.pulumi.aws.iam.inputs.GetPolicyDocumentStatementPrincipal.builder()
            .identifiers(identifiers.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDocumentStatementPrincipal].
 */
@PulumiTagMarker
public class GetPolicyDocumentStatementPrincipalBuilder internal constructor() {
    private var identifiers: List<String>? = null

    private var type: String? = null

    /**
     * @param value List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
     */
    @JvmName("ogotviargvitcvwl")
    public suspend fun identifiers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identifiers = mapped
    }

    /**
     * @param values List of identifiers for principals. When `type` is `AWS`, these are IAM principal ARNs, e.g., `arn:aws:iam::12345678901:role/yak-role`.  When `type` is `Service`, these are AWS Service roles, e.g., `lambda.amazonaws.com`. When `type` is `Federated`, these are web identity users or SAML provider ARNs, e.g., `accounts.google.com` or `arn:aws:iam::12345678901:saml-provider/yak-saml-provider`. When `type` is `CanonicalUser`, these are [canonical user IDs](https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId), e.g., `79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be`.
     */
    @JvmName("wdmxykyqjodeqhna")
    public suspend fun identifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identifiers = mapped
    }

    /**
     * @param value Type of principal. Valid values include `AWS`, `Service`, `Federated`, `CanonicalUser` and `*`.
     */
    @JvmName("smibmtepqxiclrha")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetPolicyDocumentStatementPrincipal = GetPolicyDocumentStatementPrincipal(
        identifiers = identifiers ?: throw PulumiNullFieldException("identifiers"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
