@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationContext.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The context _condition key_ to set.
 * If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
 * @property type An IAM value type that determines how the policy simulator will interpret the strings given in `values`.
 * For more information, see the `ContextKeyType` field of [`iam&#46;ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
 * @property values A set of one or more values for this context entry.
 */
public data class GetPrincipalPolicySimulationContext(
    public val key: String,
    public val type: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationContext> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationContext =
        com.pulumi.aws.iam.inputs.GetPrincipalPolicySimulationContext.builder()
            .key(key.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetPrincipalPolicySimulationContext].
 */
@PulumiTagMarker
public class GetPrincipalPolicySimulationContextBuilder internal constructor() {
    private var key: String? = null

    private var type: String? = null

    private var values: List<String>? = null

    /**
     * @param value The context _condition key_ to set.
     * If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
     */
    @JvmName("xnelkalucpkiwlqf")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value An IAM value type that determines how the policy simulator will interpret the strings given in `values`.
     * For more information, see the `ContextKeyType` field of [`iam&#46;ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
     */
    @JvmName("xhixibddjjpjxpou")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value A set of one or more values for this context entry.
     */
    @JvmName("hresamscfpuyerij")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values A set of one or more values for this context entry.
     */
    @JvmName("lpxohaflbtipcbcd")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetPrincipalPolicySimulationContext = GetPrincipalPolicySimulationContext(
        key = key ?: throw PulumiNullFieldException("key"),
        type = type ?: throw PulumiNullFieldException("type"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
