@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetRolePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRole.
 * @property name Friendly IAM role name to match.
 * @property tags Tags attached to the role.
 */
public data class GetRolePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetRolePlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetRolePlainArgs =
        com.pulumi.aws.iam.inputs.GetRolePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetRolePlainArgs].
 */
@PulumiTagMarker
public class GetRolePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Friendly IAM role name to match.
     */
    @JvmName("igwamveprxiiddpf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Tags attached to the role.
     */
    @JvmName("huoqhgevsappnguw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags attached to the role.
     */
    @JvmName("phqsbggdwqimrdlp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetRolePlainArgs = GetRolePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
