@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetSessionContextPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSessionContext.
 * @property arn ARN for an assumed role.
 * > If `arn` is a non-role ARN, Pulumi gives no error and `issuer_arn` will be equal to the `arn` value. For STS assumed-role ARNs, Pulumi gives an error if the identified IAM role does not exist.
 */
public data class GetSessionContextPlainArgs(
    public val arn: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetSessionContextPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetSessionContextPlainArgs =
        com.pulumi.aws.iam.inputs.GetSessionContextPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSessionContextPlainArgs].
 */
@PulumiTagMarker
public class GetSessionContextPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    /**
     * @param value ARN for an assumed role.
     * > If `arn` is a non-role ARN, Pulumi gives no error and `issuer_arn` will be equal to the `arn` value. For STS assumed-role ARNs, Pulumi gives an error if the identified IAM role does not exist.
     */
    @JvmName("qptkmhnimilaplwp")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    internal fun build(): GetSessionContextPlainArgs = GetSessionContextPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
