@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property tags Map of key-value pairs associated with the user.
 * @property userName Friendly IAM user name to match.
 */
public data class GetUserPlainArgs(
    public val tags: Map<String, String>? = null,
    public val userName: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetUserPlainArgs =
        com.pulumi.aws.iam.inputs.GetUserPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var userName: String? = null

    /**
     * @param value Map of key-value pairs associated with the user.
     */
    @JvmName("svdmbimuqdumanbl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of key-value pairs associated with the user.
     */
    @JvmName("nmkdajuolemdeplf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Friendly IAM user name to match.
     */
    @JvmName("xiixcrjukipowxow")
    public suspend fun userName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        tags = tags,
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
