@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.GetUserSshKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserSshKey.
 * @property encoding Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
 * @property sshPublicKeyId Unique identifier for the SSH public key.
 * @property username Name of the IAM user associated with the SSH public key.
 */
public data class GetUserSshKeyPlainArgs(
    public val encoding: String,
    public val sshPublicKeyId: String,
    public val username: String,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.GetUserSshKeyPlainArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.GetUserSshKeyPlainArgs =
        com.pulumi.aws.iam.inputs.GetUserSshKeyPlainArgs.builder()
            .encoding(encoding.let({ args0 -> args0 }))
            .sshPublicKeyId(sshPublicKeyId.let({ args0 -> args0 }))
            .username(username.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserSshKeyPlainArgs].
 */
@PulumiTagMarker
public class GetUserSshKeyPlainArgsBuilder internal constructor() {
    private var encoding: String? = null

    private var sshPublicKeyId: String? = null

    private var username: String? = null

    /**
     * @param value Specifies the public key encoding format to use in the response. To retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the public key in PEM format, use `PEM`.
     */
    @JvmName("hdkhiipyjwfptaqy")
    public suspend fun encoding(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encoding = mapped
    }

    /**
     * @param value Unique identifier for the SSH public key.
     */
    @JvmName("rhvvhlxljaeagdgw")
    public suspend fun sshPublicKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sshPublicKeyId = mapped
    }

    /**
     * @param value Name of the IAM user associated with the SSH public key.
     */
    @JvmName("nvhhqiixktitwkvp")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.username = mapped
    }

    internal fun build(): GetUserSshKeyPlainArgs = GetUserSshKeyPlainArgs(
        encoding = encoding ?: throw PulumiNullFieldException("encoding"),
        sshPublicKeyId = sshPublicKeyId ?: throw PulumiNullFieldException("sshPublicKeyId"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
