@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.inputs

import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the role policy.
 * @property policy Policy document as a JSON formatted string.
 */
public data class RoleInlinePolicyArgs(
    public val name: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs> {
    override fun toJava(): com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs =
        com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleInlinePolicyArgs].
 */
@PulumiTagMarker
public class RoleInlinePolicyArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value Name of the role policy.
     */
    @JvmName("yfoxixoavblnrorg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Policy document as a JSON formatted string.
     */
    @JvmName("lgfyaoxmlkqunggx")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name of the role policy.
     */
    @JvmName("bdsjsopnldheyipb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Policy document as a JSON formatted string.
     */
    @JvmName("ijcrcarwbxenrgrq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): RoleInlinePolicyArgs = RoleInlinePolicyArgs(
        name = name,
        policy = policy,
    )
}
