@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessKeyId Access key ID.
 * @property createDate Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the access key was created.
 * @property status Access key status. Possible values are `Active` and `Inactive`.
 */
public data class GetAccessKeysAccessKey(
    public val accessKeyId: String,
    public val createDate: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetAccessKeysAccessKey): GetAccessKeysAccessKey = GetAccessKeysAccessKey(
            accessKeyId = javaType.accessKeyId(),
            createDate = javaType.createDate(),
            status = javaType.status(),
        )
    }
}
