@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessKeys.
 * @property accessKeys List of the IAM access keys associated with the specified user. See below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property user
 */
public data class GetAccessKeysResult(
    public val accessKeys: List<GetAccessKeysAccessKey>,
    public val id: String,
    public val user: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetAccessKeysResult): GetAccessKeysResult = GetAccessKeysResult(
            accessKeys = javaType.accessKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetAccessKeysAccessKey.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            user = javaType.user(),
        )
    }
}
