@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroup.
 * @property arn User ARN.
 * @property groupId Stable and unique string identifying the group.
 * @property groupName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property path Path to the IAM user.
 * @property users List of objects containing group member information. See below.
 */
public data class GetGroupResult(
    public val arn: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val path: String,
    public val users: List<GetGroupUser>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetGroupResult): GetGroupResult =
            GetGroupResult(
                arn = javaType.arn(),
                groupId = javaType.groupId(),
                groupName = javaType.groupName(),
                id = javaType.id(),
                path = javaType.path(),
                users = javaType.users().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iam.kotlin.outputs.GetGroupUser.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
