@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn User ARN.
 * @property path Path to the IAM user.
 * @property userId Stable and unique string identifying the IAM user.
 * @property userName Name of the IAM user.
 */
public data class GetGroupUser(
    public val arn: String,
    public val path: String,
    public val userId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetGroupUser): GetGroupUser =
            GetGroupUser(
                arn = javaType.arn(),
                path = javaType.path(),
                userId = javaType.userId(),
                userName = javaType.userName(),
            )
    }
}
