@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getInstanceProfile.
 * @property arn ARN.
 * @property createDate String representation of the date the instance profile was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property path Path to the instance profile.
 * @property roleArn Role ARN associated with this instance profile.
 * @property roleId Role ID associated with this instance profile.
 * @property roleName Role name associated with this instance profile.
 */
public data class GetInstanceProfileResult(
    public val arn: String,
    public val createDate: String,
    public val id: String,
    public val name: String,
    public val path: String,
    public val roleArn: String,
    public val roleId: String,
    public val roleName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetInstanceProfileResult): GetInstanceProfileResult = GetInstanceProfileResult(
            arn = javaType.arn(),
            createDate = javaType.createDate(),
            id = javaType.id(),
            name = javaType.name(),
            path = javaType.path(),
            roleArn = javaType.roleArn(),
            roleId = javaType.roleId(),
            roleName = javaType.roleName(),
        )
    }
}
