@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstanceProfiles.
 * @property arns Set of ARNs of instance profiles.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of IAM instance profile names.
 * @property paths Set of IAM instance profile paths.
 * @property roleName
 */
public data class GetInstanceProfilesResult(
    public val arns: List<String>,
    public val id: String,
    public val names: List<String>,
    public val paths: List<String>,
    public val roleName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetInstanceProfilesResult): GetInstanceProfilesResult = GetInstanceProfilesResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
            paths = javaType.paths().map({ args0 -> args0 }),
            roleName = javaType.roleName(),
        )
    }
}
