@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPolicyDocument.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json Standard JSON policy document rendered based on the arguments above.
 * @property minifiedJson Minified JSON policy document rendered based on the arguments above.
 * @property overrideJson
 * @property overridePolicyDocuments
 * @property policyId
 * @property sourceJson
 * @property sourcePolicyDocuments
 * @property statements
 * @property version
 */
public data class GetPolicyDocumentResult(
    public val id: String,
    public val json: String,
    public val minifiedJson: String,
    @Deprecated(
        message = """
  Not used
  """,
    )
    public val overrideJson: String? = null,
    public val overridePolicyDocuments: List<String>? = null,
    public val policyId: String? = null,
    @Deprecated(
        message = """
  Not used
  """,
    )
    public val sourceJson: String? = null,
    public val sourcePolicyDocuments: List<String>? = null,
    public val statements: List<GetPolicyDocumentStatement>? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPolicyDocumentResult): GetPolicyDocumentResult = GetPolicyDocumentResult(
            id = javaType.id(),
            json = javaType.json(),
            minifiedJson = javaType.minifiedJson(),
            overrideJson = javaType.overrideJson().map({ args0 -> args0 }).orElse(null),
            overridePolicyDocuments = javaType.overridePolicyDocuments().map({ args0 -> args0 }),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            sourceJson = javaType.sourceJson().map({ args0 -> args0 }).orElse(null),
            sourcePolicyDocuments = javaType.sourcePolicyDocuments().map({ args0 -> args0 }),
            statements = javaType.statements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentStatement.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
