@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPolicy.
 * @property arn ARN of the policy.
 * @property attachmentCount Number of entities (users, groups, and roles) that the policy is attached to.
 * @property description Description of the policy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property path Path to the policy.
 * @property pathPrefix
 * @property policy Policy document of the policy.
 * @property policyId Policy's ID.
 * @property tags Key-value mapping of tags for the IAM Policy.
 */
public data class GetPolicyResult(
    public val arn: String,
    public val attachmentCount: Int,
    public val description: String,
    public val id: String,
    public val name: String,
    public val path: String,
    public val pathPrefix: String? = null,
    public val policy: String,
    public val policyId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPolicyResult): GetPolicyResult =
            GetPolicyResult(
                arn = javaType.arn(),
                attachmentCount = javaType.attachmentCount(),
                description = javaType.description(),
                id = javaType.id(),
                name = javaType.name(),
                path = javaType.path(),
                pathPrefix = javaType.pathPrefix().map({ args0 -> args0 }).orElse(null),
                policy = javaType.policy(),
                policyId = javaType.policyId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
