@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPrincipalPolicySimulation.
 * @property actionNames
 * @property additionalPoliciesJsons
 * @property allAllowed `true` if all of the simulation results have decision "allowed", or `false` otherwise.
 * @property callerArn
 * @property contexts
 * @property id
 * @property permissionsBoundaryPoliciesJsons
 * @property policySourceArn
 * @property resourceArns
 * @property resourceHandlingOption
 * @property resourceOwnerAccountId
 * @property resourcePolicyJson
 * @property results A set of result objects, one for each of the simulated requests, with the following nested attributes:
 */
public data class GetPrincipalPolicySimulationInvokeResult(
    public val actionNames: List<String>,
    public val additionalPoliciesJsons: List<String>? = null,
    public val allAllowed: Boolean,
    public val callerArn: String? = null,
    public val contexts: List<GetPrincipalPolicySimulationContext>? = null,
    public val id: String,
    public val permissionsBoundaryPoliciesJsons: List<String>? = null,
    public val policySourceArn: String,
    public val resourceArns: List<String>? = null,
    public val resourceHandlingOption: String? = null,
    public val resourceOwnerAccountId: String? = null,
    public val resourcePolicyJson: String? = null,
    public val results: List<GetPrincipalPolicySimulationResult>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPrincipalPolicySimulationInvokeResult): GetPrincipalPolicySimulationInvokeResult = GetPrincipalPolicySimulationInvokeResult(
            actionNames = javaType.actionNames().map({ args0 -> args0 }),
            additionalPoliciesJsons = javaType.additionalPoliciesJsons().map({ args0 -> args0 }),
            allAllowed = javaType.allAllowed(),
            callerArn = javaType.callerArn().map({ args0 -> args0 }).orElse(null),
            contexts = javaType.contexts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationContext.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            permissionsBoundaryPoliciesJsons = javaType.permissionsBoundaryPoliciesJsons().map({ args0 ->
                args0
            }),
            policySourceArn = javaType.policySourceArn(),
            resourceArns = javaType.resourceArns().map({ args0 -> args0 }),
            resourceHandlingOption = javaType.resourceHandlingOption().map({ args0 -> args0 }).orElse(null),
            resourceOwnerAccountId = javaType.resourceOwnerAccountId().map({ args0 -> args0 }).orElse(null),
            resourcePolicyJson = javaType.resourcePolicyJson().map({ args0 -> args0 }).orElse(null),
            results = javaType.results().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationResult.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
