@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRole.
 * @property arn ARN of the role.
 * @property assumeRolePolicy Policy document associated with the role.
 * @property createDate Creation date of the role in RFC 3339 format.
 * @property description Description for the role.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property maxSessionDuration Maximum session duration.
 * @property name
 * @property path Path to the role.
 * @property permissionsBoundary The ARN of the policy that is used to set the permissions boundary for the role.
 * @property roleLastUseds Contains information about the last time that an IAM role was used. See `role_last_used` for details.
 * @property tags Tags attached to the role.
 * @property uniqueId Stable and unique string identifying the role.
 */
public data class GetRoleResult(
    public val arn: String,
    public val assumeRolePolicy: String,
    public val createDate: String,
    public val description: String,
    public val id: String,
    public val maxSessionDuration: Int,
    public val name: String,
    public val path: String,
    public val permissionsBoundary: String,
    public val roleLastUseds: List<GetRoleRoleLastUsed>,
    public val tags: Map<String, String>,
    public val uniqueId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetRoleResult): GetRoleResult =
            GetRoleResult(
                arn = javaType.arn(),
                assumeRolePolicy = javaType.assumeRolePolicy(),
                createDate = javaType.createDate(),
                description = javaType.description(),
                id = javaType.id(),
                maxSessionDuration = javaType.maxSessionDuration(),
                name = javaType.name(),
                path = javaType.path(),
                permissionsBoundary = javaType.permissionsBoundary(),
                roleLastUseds = javaType.roleLastUseds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.iam.kotlin.outputs.GetRoleRoleLastUsed.Companion.toKotlin(args0)
                    })
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                uniqueId = javaType.uniqueId(),
            )
    }
}
