@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lastUsedDate The date and time, in RFC 3339 format, that the role was last used.
 * @property region The name of the AWS Region in which the role was last used.
 */
public data class GetRoleRoleLastUsed(
    public val lastUsedDate: String,
    public val region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetRoleRoleLastUsed): GetRoleRoleLastUsed = GetRoleRoleLastUsed(
            lastUsedDate = javaType.lastUsedDate(),
            region = javaType.region(),
        )
    }
}
