@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRoles.
 * @property arns Set of ARNs of the matched IAM roles.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property nameRegex
 * @property names Set of Names of the matched IAM roles.
 * @property pathPrefix
 */
public data class GetRolesResult(
    public val arns: List<String>,
    public val id: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val pathPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetRolesResult): GetRolesResult =
            GetRolesResult(
                arns = javaType.arns().map({ args0 -> args0 }),
                id = javaType.id(),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                names = javaType.names().map({ args0 -> args0 }),
                pathPrefix = javaType.pathPrefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
