@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getUserSshKey.
 * @property encoding
 * @property fingerprint MD5 message digest of the SSH public key.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property publicKey SSH public key.
 * @property sshPublicKeyId
 * @property status Status of the SSH public key. Active means that the key can be used for authentication with an CodeCommit repository. Inactive means that the key cannot be used.
 * @property username
 */
public data class GetUserSshKeyResult(
    public val encoding: String,
    public val fingerprint: String,
    public val id: String,
    public val publicKey: String,
    public val sshPublicKeyId: String,
    public val status: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetUserSshKeyResult): GetUserSshKeyResult = GetUserSshKeyResult(
            encoding = javaType.encoding(),
            fingerprint = javaType.fingerprint(),
            id = javaType.id(),
            publicKey = javaType.publicKey(),
            sshPublicKeyId = javaType.sshPublicKeyId(),
            status = javaType.status(),
            username = javaType.username(),
        )
    }
}
