@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IdentityStore Group.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _this = new aws.identitystore.Group("this", {
 *     displayName: "Example group",
 *     description: "Example description",
 *     identityStoreId: example.identityStoreIds[0],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * this = aws.identitystore.Group("this",
 *     display_name="Example group",
 *     description="Example description",
 *     identity_store_id=example["identityStoreIds"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new Aws.IdentityStore.Group("this", new()
 *     {
 *         DisplayName = "Example group",
 *         Description = "Example description",
 *         IdentityStoreId = example.IdentityStoreIds[0],
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := identitystore.NewGroup(ctx, "this", &identitystore.GroupArgs{
 * 			DisplayName:     pulumi.String("Example group"),
 * 			Description:     pulumi.String("Example description"),
 * 			IdentityStoreId: pulumi.Any(example.IdentityStoreIds[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.identitystore.Group;
 * import com.pulumi.aws.identitystore.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Group("this", GroupArgs.builder()
 *             .displayName("Example group")
 *             .description("Example description")
 *             .identityStoreId(example.identityStoreIds()[0])
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: aws:identitystore:Group
 *     properties:
 *       displayName: Example group
 *       description: Example description
 *       identityStoreId: ${example.identityStoreIds[0]}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an Identity Store Group using the combination `identity_store_id/group_id`. For example:
 * ```sh
 * $ pulumi import aws:identitystore/group:Group example d-9c6705e95c/b8a1c340-8031-7071-a2fb-7dc540320c30
 * ```
 * @property description A string containing the description of the group.
 * @property displayName A string containing the name of the group. This value is commonly displayed when the group is referenced.
 * @property identityStoreId The globally unique identifier for the identity store.
 * The following arguments are optional:
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identityStoreId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.GroupArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.GroupArgs =
        com.pulumi.aws.identitystore.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identityStoreId(identityStoreId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identityStoreId: Output<String>? = null

    /**
     * @param value A string containing the description of the group.
     */
    @JvmName("aeotbdktdufdwvms")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A string containing the name of the group. This value is commonly displayed when the group is referenced.
     */
    @JvmName("qmwebiwkxmpkismp")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The globally unique identifier for the identity store.
     * The following arguments are optional:
     */
    @JvmName("rdpsfphgwqomhdah")
    public suspend fun identityStoreId(`value`: Output<String>) {
        this.identityStoreId = value
    }

    /**
     * @param value A string containing the description of the group.
     */
    @JvmName("osclrdaifnbmdtrr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A string containing the name of the group. This value is commonly displayed when the group is referenced.
     */
    @JvmName("swxkiieccsoyoesu")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The globally unique identifier for the identity store.
     * The following arguments are optional:
     */
    @JvmName("wmkhlagabnydtnol")
    public suspend fun identityStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityStoreId = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        displayName = displayName,
        identityStoreId = identityStoreId,
    )
}
