@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.aws.identitystore.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IdentityStore Group Membership.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleUser = new aws.identitystore.User("example", {
 *     identityStoreId: example.then(example => example.identityStoreIds?.[0]),
 *     displayName: "John Doe",
 *     userName: "john.doe@example.com",
 *     name: {
 *         familyName: "Doe",
 *         givenName: "John",
 *     },
 * });
 * const exampleGroup = new aws.identitystore.Group("example", {
 *     identityStoreId: example.then(example => example.identityStoreIds?.[0]),
 *     displayName: "MyGroup",
 *     description: "Some group name",
 * });
 * const exampleGroupMembership = new aws.identitystore.GroupMembership("example", {
 *     identityStoreId: example.then(example => example.identityStoreIds?.[0]),
 *     groupId: exampleGroup.groupId,
 *     memberId: exampleUser.userId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_user = aws.identitystore.User("example",
 *     identity_store_id=example.identity_store_ids[0],
 *     display_name="John Doe",
 *     user_name="john.doe@example.com",
 *     name={
 *         "family_name": "Doe",
 *         "given_name": "John",
 *     })
 * example_group = aws.identitystore.Group("example",
 *     identity_store_id=example.identity_store_ids[0],
 *     display_name="MyGroup",
 *     description="Some group name")
 * example_group_membership = aws.identitystore.GroupMembership("example",
 *     identity_store_id=example.identity_store_ids[0],
 *     group_id=example_group.group_id,
 *     member_id=example_user.user_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleUser = new Aws.IdentityStore.User("example", new()
 *     {
 *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
 *         DisplayName = "John Doe",
 *         UserName = "john.doe@example.com",
 *         Name = new Aws.IdentityStore.Inputs.UserNameArgs
 *         {
 *             FamilyName = "Doe",
 *             GivenName = "John",
 *         },
 *     });
 *     var exampleGroup = new Aws.IdentityStore.Group("example", new()
 *     {
 *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
 *         DisplayName = "MyGroup",
 *         Description = "Some group name",
 *     });
 *     var exampleGroupMembership = new Aws.IdentityStore.GroupMembership("example", new()
 *     {
 *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
 *         GroupId = exampleGroup.GroupId,
 *         MemberId = exampleUser.UserId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleUser, err := identitystore.NewUser(ctx, "example", &identitystore.UserArgs{
 * 			IdentityStoreId: pulumi.String(example.IdentityStoreIds[0]),
 * 			DisplayName:     pulumi.String("John Doe"),
 * 			UserName:        pulumi.String("john.doe@example.com"),
 * 			Name: &identitystore.UserNameArgs{
 * 				FamilyName: pulumi.String("Doe"),
 * 				GivenName:  pulumi.String("John"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGroup, err := identitystore.NewGroup(ctx, "example", &identitystore.GroupArgs{
 * 			IdentityStoreId: pulumi.String(example.IdentityStoreIds[0]),
 * 			DisplayName:     pulumi.String("MyGroup"),
 * 			Description:     pulumi.String("Some group name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = identitystore.NewGroupMembership(ctx, "example", &identitystore.GroupMembershipArgs{
 * 			IdentityStoreId: pulumi.String(example.IdentityStoreIds[0]),
 * 			GroupId:         exampleGroup.GroupId,
 * 			MemberId:        exampleUser.UserId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.identitystore.User;
 * import com.pulumi.aws.identitystore.UserArgs;
 * import com.pulumi.aws.identitystore.inputs.UserNameArgs;
 * import com.pulumi.aws.identitystore.Group;
 * import com.pulumi.aws.identitystore.GroupArgs;
 * import com.pulumi.aws.identitystore.GroupMembership;
 * import com.pulumi.aws.identitystore.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
 *             .displayName("John Doe")
 *             .userName("john.doe@example.com")
 *             .name(UserNameArgs.builder()
 *                 .familyName("Doe")
 *                 .givenName("John")
 *                 .build())
 *             .build());
 *         var exampleGroup = new Group("exampleGroup", GroupArgs.builder()
 *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
 *             .displayName("MyGroup")
 *             .description("Some group name")
 *             .build());
 *         var exampleGroupMembership = new GroupMembership("exampleGroupMembership", GroupMembershipArgs.builder()
 *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
 *             .groupId(exampleGroup.groupId())
 *             .memberId(exampleUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleUser:
 *     type: aws:identitystore:User
 *     name: example
 *     properties:
 *       identityStoreId: ${example.identityStoreIds[0]}
 *       displayName: John Doe
 *       userName: john.doe@example.com
 *       name:
 *         familyName: Doe
 *         givenName: John
 *   exampleGroup:
 *     type: aws:identitystore:Group
 *     name: example
 *     properties:
 *       identityStoreId: ${example.identityStoreIds[0]}
 *       displayName: MyGroup
 *       description: Some group name
 *   exampleGroupMembership:
 *     type: aws:identitystore:GroupMembership
 *     name: example
 *     properties:
 *       identityStoreId: ${example.identityStoreIds[0]}
 *       groupId: ${exampleGroup.groupId}
 *       memberId: ${exampleUser.userId}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_identitystore_group_membership` using the `identity_store_id/membership_id`. For example:
 * ```sh
 * $ pulumi import aws:identitystore/groupMembership:GroupMembership example d-0000000000/00000000-0000-0000-0000-000000000000
 * ```
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.identitystore.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    /**
     * The identifier for a group in the Identity Store.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * Identity Store ID associated with the Single Sign-On Instance.
     */
    public val identityStoreId: Output<String>
        get() = javaResource.identityStoreId().applyValue({ args0 -> args0 })

    /**
     * The identifier for a user in the Identity Store.
     */
    public val memberId: Output<String>
        get() = javaResource.memberId().applyValue({ args0 -> args0 })

    /**
     * The identifier of the newly created group membership in the Identity Store.
     */
    public val membershipId: Output<String>
        get() = javaResource.membershipId().applyValue({ args0 -> args0 })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.identitystore.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.aws.identitystore.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
