@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.IdentitystoreFunctions.getGroupPlain
import com.pulumi.aws.identitystore.IdentitystoreFunctions.getGroupsPlain
import com.pulumi.aws.identitystore.IdentitystoreFunctions.getUserPlain
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupAlternateIdentifier
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupFilter
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserAlternateIdentifier
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserFilter
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupResult
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupsResult
import com.pulumi.aws.identitystore.kotlin.outputs.GetUserResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.aws.identitystore.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin

public object IdentitystoreFunctions {
    /**
     * Use this data source to get an Identity Store Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * const exampleGetGroup = example.then(example => aws.identitystore.getGroup({
     *     identityStoreId: example.identityStoreIds?.[0],
     *     alternateIdentifier: {
     *         uniqueAttribute: {
     *             attributePath: "DisplayName",
     *             attributeValue: "ExampleGroup",
     *         },
     *     },
     * }));
     * export const groupId = exampleGetGroup.then(exampleGetGroup => exampleGetGroup.groupId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * example_get_group = aws.identitystore.get_group(identity_store_id=example.identity_store_ids[0],
     *     alternate_identifier={
     *         "unique_attribute": {
     *             "attribute_path": "DisplayName",
     *             "attribute_value": "ExampleGroup",
     *         },
     *     })
     * pulumi.export("groupId", example_get_group.group_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     var exampleGetGroup = Aws.IdentityStore.GetGroup.Invoke(new()
     *     {
     *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
     *         AlternateIdentifier = new Aws.IdentityStore.Inputs.GetGroupAlternateIdentifierInputArgs
     *         {
     *             UniqueAttribute = new Aws.IdentityStore.Inputs.GetGroupAlternateIdentifierUniqueAttributeInputArgs
     *             {
     *                 AttributePath = "DisplayName",
     *                 AttributeValue = "ExampleGroup",
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["groupId"] = exampleGetGroup.Apply(getGroupResult => getGroupResult.GroupId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		exampleGetGroup, err := identitystore.LookupGroup(ctx, &identitystore.LookupGroupArgs{
     * 			IdentityStoreId: example.IdentityStoreIds[0],
     * 			AlternateIdentifier: identitystore.GetGroupAlternateIdentifier{
     * 				UniqueAttribute: identitystore.GetGroupAlternateIdentifierUniqueAttribute{
     * 					AttributePath:  "DisplayName",
     * 					AttributeValue: "ExampleGroup",
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("groupId", exampleGetGroup.GroupId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.identitystore.IdentitystoreFunctions;
     * import com.pulumi.aws.identitystore.inputs.GetGroupArgs;
     * import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierArgs;
     * import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierUniqueAttributeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         final var exampleGetGroup = IdentitystoreFunctions.getGroup(GetGroupArgs.builder()
     *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
     *             .alternateIdentifier(GetGroupAlternateIdentifierArgs.builder()
     *                 .uniqueAttribute(GetGroupAlternateIdentifierUniqueAttributeArgs.builder()
     *                     .attributePath("DisplayName")
     *                     .attributeValue("ExampleGroup")
     *                     .build())
     *                 .build())
     *             .build());
     *         ctx.export("groupId", exampleGetGroup.applyValue(getGroupResult -> getGroupResult.groupId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     *   exampleGetGroup:
     *     fn::invoke:
     *       Function: aws:identitystore:getGroup
     *       Arguments:
     *         identityStoreId: ${example.identityStoreIds[0]}
     *         alternateIdentifier:
     *           uniqueAttribute:
     *             attributePath: DisplayName
     *             attributeValue: ExampleGroup
     * outputs:
     *   groupId: ${exampleGetGroup.groupId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param alternateIdentifier A unique identifier for the group that is not the primary identifier. Conflicts with `group_id` and `filter`. Detailed below.
     * @param filter Configuration block for filtering by a unique attribute of the group. Detailed below.
     * @param groupId The identifier for a group in the Identity Store.
     * > Exactly one of the above arguments must be provided. Passing both `filter` and `group_id` is allowed for backwards compatibility.
     * @param identityStoreId Identity Store ID associated with the Single Sign-On Instance.
     * The following arguments are optional:
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(
        alternateIdentifier: GetGroupAlternateIdentifier? = null,
        filter: GetGroupFilter? = null,
        groupId: String? = null,
        identityStoreId: String,
    ): GetGroupResult {
        val argument = GetGroupPlainArgs(
            alternateIdentifier = alternateIdentifier,
            filter = filter,
            groupId = groupId,
            identityStoreId = identityStoreId,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;identitystore&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit): GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SSO Identity Store Groups.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * const exampleGetGroups = example.then(example => aws.identitystore.getGroups({
     *     identityStoreId: example.identityStoreIds?.[0],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * example_get_groups = aws.identitystore.get_groups(identity_store_id=example.identity_store_ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     var exampleGetGroups = Aws.IdentityStore.GetGroups.Invoke(new()
     *     {
     *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = identitystore.GetGroups(ctx, &identitystore.GetGroupsArgs{
     * 			IdentityStoreId: example.IdentityStoreIds[0],
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.identitystore.IdentitystoreFunctions;
     * import com.pulumi.aws.identitystore.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         final var exampleGetGroups = IdentitystoreFunctions.getGroups(GetGroupsArgs.builder()
     *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     *   exampleGetGroups:
     *     fn::invoke:
     *       Function: aws:identitystore:getGroups
     *       Arguments:
     *         identityStoreId: ${example.identityStoreIds[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param identityStoreId Identity Store ID associated with the Single Sign-On (SSO) Instance.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(identityStoreId: String): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            identityStoreId = identityStoreId,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;identitystore&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get an Identity Store User.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * const exampleGetUser = example.then(example => aws.identitystore.getUser({
     *     identityStoreId: example.identityStoreIds?.[0],
     *     alternateIdentifier: {
     *         uniqueAttribute: {
     *             attributePath: "UserName",
     *             attributeValue: "ExampleUser",
     *         },
     *     },
     * }));
     * export const userId = exampleGetUser.then(exampleGetUser => exampleGetUser.userId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * example_get_user = aws.identitystore.get_user(identity_store_id=example.identity_store_ids[0],
     *     alternate_identifier={
     *         "unique_attribute": {
     *             "attribute_path": "UserName",
     *             "attribute_value": "ExampleUser",
     *         },
     *     })
     * pulumi.export("userId", example_get_user.user_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     var exampleGetUser = Aws.IdentityStore.GetUser.Invoke(new()
     *     {
     *         IdentityStoreId = example.Apply(getInstancesResult => getInstancesResult.IdentityStoreIds[0]),
     *         AlternateIdentifier = new Aws.IdentityStore.Inputs.GetUserAlternateIdentifierInputArgs
     *         {
     *             UniqueAttribute = new Aws.IdentityStore.Inputs.GetUserAlternateIdentifierUniqueAttributeInputArgs
     *             {
     *                 AttributePath = "UserName",
     *                 AttributeValue = "ExampleUser",
     *             },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["userId"] = exampleGetUser.Apply(getUserResult => getUserResult.UserId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		exampleGetUser, err := identitystore.LookupUser(ctx, &identitystore.LookupUserArgs{
     * 			IdentityStoreId: example.IdentityStoreIds[0],
     * 			AlternateIdentifier: identitystore.GetUserAlternateIdentifier{
     * 				UniqueAttribute: identitystore.GetUserAlternateIdentifierUniqueAttribute{
     * 					AttributePath:  "UserName",
     * 					AttributeValue: "ExampleUser",
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("userId", exampleGetUser.UserId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.identitystore.IdentitystoreFunctions;
     * import com.pulumi.aws.identitystore.inputs.GetUserArgs;
     * import com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifierArgs;
     * import com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifierUniqueAttributeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         final var exampleGetUser = IdentitystoreFunctions.getUser(GetUserArgs.builder()
     *             .identityStoreId(example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]))
     *             .alternateIdentifier(GetUserAlternateIdentifierArgs.builder()
     *                 .uniqueAttribute(GetUserAlternateIdentifierUniqueAttributeArgs.builder()
     *                     .attributePath("UserName")
     *                     .attributeValue("ExampleUser")
     *                     .build())
     *                 .build())
     *             .build());
     *         ctx.export("userId", exampleGetUser.applyValue(getUserResult -> getUserResult.userId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     *   exampleGetUser:
     *     fn::invoke:
     *       Function: aws:identitystore:getUser
     *       Arguments:
     *         identityStoreId: ${example.identityStoreIds[0]}
     *         alternateIdentifier:
     *           uniqueAttribute:
     *             attributePath: UserName
     *             attributeValue: ExampleUser
     * outputs:
     *   userId: ${exampleGetUser.userId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param alternateIdentifier A unique identifier for a user or group that is not the primary identifier. Conflicts with `user_id` and `filter`. Detailed below.
     * @param filter Configuration block for filtering by a unique attribute of the user. Detailed below.
     * @param identityStoreId Identity Store ID associated with the Single Sign-On Instance.
     * The following arguments are optional:
     * @param userId The identifier for a user in the Identity Store.
     * > Exactly one of the above arguments must be provided. Passing both `filter` and `user_id` is allowed for backwards compatibility.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(
        alternateIdentifier: GetUserAlternateIdentifier? = null,
        filter: GetUserFilter? = null,
        identityStoreId: String,
        userId: String? = null,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            alternateIdentifier = alternateIdentifier,
            filter = filter,
            identityStoreId = identityStoreId,
            userId = userId,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;identitystore&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }
}
