@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.UserArgs.builder
import com.pulumi.aws.identitystore.kotlin.inputs.UserAddressesArgs
import com.pulumi.aws.identitystore.kotlin.inputs.UserAddressesArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.UserEmailsArgs
import com.pulumi.aws.identitystore.kotlin.inputs.UserEmailsArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.UserNameArgs
import com.pulumi.aws.identitystore.kotlin.inputs.UserNameArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.UserPhoneNumbersArgs
import com.pulumi.aws.identitystore.kotlin.inputs.UserPhoneNumbersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This resource manages a User resource within an Identity Store.
 * > **Note:** If you use an external identity provider or Active Directory as your identity source,
 * use this resource with caution. IAM Identity Center does not support outbound synchronization,
 * so your identity source does not automatically update with the changes that you make to
 * users using this resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.identitystore.User("example", {
 *     identityStoreId: exampleAwsSsoadminInstances.identityStoreIds[0],
 *     displayName: "John Doe",
 *     userName: "johndoe",
 *     name: {
 *         givenName: "John",
 *         familyName: "Doe",
 *     },
 *     emails: {
 *         value: "john@example.com",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.identitystore.User("example",
 *     identity_store_id=example_aws_ssoadmin_instances["identityStoreIds"],
 *     display_name="John Doe",
 *     user_name="johndoe",
 *     name={
 *         "given_name": "John",
 *         "family_name": "Doe",
 *     },
 *     emails={
 *         "value": "john@example.com",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.IdentityStore.User("example", new()
 *     {
 *         IdentityStoreId = exampleAwsSsoadminInstances.IdentityStoreIds[0],
 *         DisplayName = "John Doe",
 *         UserName = "johndoe",
 *         Name = new Aws.IdentityStore.Inputs.UserNameArgs
 *         {
 *             GivenName = "John",
 *             FamilyName = "Doe",
 *         },
 *         Emails = new Aws.IdentityStore.Inputs.UserEmailsArgs
 *         {
 *             Value = "john@example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/identitystore"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := identitystore.NewUser(ctx, "example", &identitystore.UserArgs{
 * 			IdentityStoreId: pulumi.Any(exampleAwsSsoadminInstances.IdentityStoreIds[0]),
 * 			DisplayName:     pulumi.String("John Doe"),
 * 			UserName:        pulumi.String("johndoe"),
 * 			Name: &identitystore.UserNameArgs{
 * 				GivenName:  pulumi.String("John"),
 * 				FamilyName: pulumi.String("Doe"),
 * 			},
 * 			Emails: &identitystore.UserEmailsArgs{
 * 				Value: pulumi.String("john@example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.identitystore.User;
 * import com.pulumi.aws.identitystore.UserArgs;
 * import com.pulumi.aws.identitystore.inputs.UserNameArgs;
 * import com.pulumi.aws.identitystore.inputs.UserEmailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .identityStoreId(exampleAwsSsoadminInstances.identityStoreIds()[0])
 *             .displayName("John Doe")
 *             .userName("johndoe")
 *             .name(UserNameArgs.builder()
 *                 .givenName("John")
 *                 .familyName("Doe")
 *                 .build())
 *             .emails(UserEmailsArgs.builder()
 *                 .value("john@example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:identitystore:User
 *     properties:
 *       identityStoreId: ${exampleAwsSsoadminInstances.identityStoreIds[0]}
 *       displayName: John Doe
 *       userName: johndoe
 *       name:
 *         givenName: John
 *         familyName: Doe
 *       emails:
 *         value: john@example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an Identity Store User using the combination `identity_store_id/user_id`. For example:
 * ```sh
 * $ pulumi import aws:identitystore/user:User example d-9c6705e95c/065212b4-9061-703b-5876-13a517ae2a7c
 * ```
 * @property addresses Details about the user's address. At most 1 address is allowed. Detailed below.
 * @property displayName The name that is typically displayed when the user is referenced.
 * @property emails Details about the user's email. At most 1 email is allowed. Detailed below.
 * @property identityStoreId The globally unique identifier for the identity store that this user is in.
 * @property locale The user's geographical region or location.
 * @property name Details about the user's full name. Detailed below.
 * @property nickname An alternate name for the user.
 * @property phoneNumbers Details about the user's phone number. At most 1 phone number is allowed. Detailed below.
 * @property preferredLanguage The preferred language of the user.
 * @property profileUrl An URL that may be associated with the user.
 * @property timezone The user's time zone.
 * @property title The user's title.
 * @property userName A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
 * The following arguments are optional:
 * @property userType The user type.
 */
public data class UserArgs(
    public val addresses: Output<UserAddressesArgs>? = null,
    public val displayName: Output<String>? = null,
    public val emails: Output<UserEmailsArgs>? = null,
    public val identityStoreId: Output<String>? = null,
    public val locale: Output<String>? = null,
    public val name: Output<UserNameArgs>? = null,
    public val nickname: Output<String>? = null,
    public val phoneNumbers: Output<UserPhoneNumbersArgs>? = null,
    public val preferredLanguage: Output<String>? = null,
    public val profileUrl: Output<String>? = null,
    public val timezone: Output<String>? = null,
    public val title: Output<String>? = null,
    public val userName: Output<String>? = null,
    public val userType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.UserArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.UserArgs =
        com.pulumi.aws.identitystore.UserArgs.builder()
            .addresses(addresses?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .emails(emails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityStoreId(identityStoreId?.applyValue({ args0 -> args0 }))
            .locale(locale?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nickname(nickname?.applyValue({ args0 -> args0 }))
            .phoneNumbers(phoneNumbers?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preferredLanguage(preferredLanguage?.applyValue({ args0 -> args0 }))
            .profileUrl(profileUrl?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .userType(userType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var addresses: Output<UserAddressesArgs>? = null

    private var displayName: Output<String>? = null

    private var emails: Output<UserEmailsArgs>? = null

    private var identityStoreId: Output<String>? = null

    private var locale: Output<String>? = null

    private var name: Output<UserNameArgs>? = null

    private var nickname: Output<String>? = null

    private var phoneNumbers: Output<UserPhoneNumbersArgs>? = null

    private var preferredLanguage: Output<String>? = null

    private var profileUrl: Output<String>? = null

    private var timezone: Output<String>? = null

    private var title: Output<String>? = null

    private var userName: Output<String>? = null

    private var userType: Output<String>? = null

    /**
     * @param value Details about the user's address. At most 1 address is allowed. Detailed below.
     */
    @JvmName("sasrjlaothsvtpwy")
    public suspend fun addresses(`value`: Output<UserAddressesArgs>) {
        this.addresses = value
    }

    /**
     * @param value The name that is typically displayed when the user is referenced.
     */
    @JvmName("sqrwlehnhtrcdmhx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Details about the user's email. At most 1 email is allowed. Detailed below.
     */
    @JvmName("nxkmdjexuyeicacs")
    public suspend fun emails(`value`: Output<UserEmailsArgs>) {
        this.emails = value
    }

    /**
     * @param value The globally unique identifier for the identity store that this user is in.
     */
    @JvmName("fcygkuwlsiaphuby")
    public suspend fun identityStoreId(`value`: Output<String>) {
        this.identityStoreId = value
    }

    /**
     * @param value The user's geographical region or location.
     */
    @JvmName("tvbylpgghcaestvx")
    public suspend fun locale(`value`: Output<String>) {
        this.locale = value
    }

    /**
     * @param value Details about the user's full name. Detailed below.
     */
    @JvmName("gluwnxvyxudllscm")
    public suspend fun name(`value`: Output<UserNameArgs>) {
        this.name = value
    }

    /**
     * @param value An alternate name for the user.
     */
    @JvmName("joshasjurmoyrhxf")
    public suspend fun nickname(`value`: Output<String>) {
        this.nickname = value
    }

    /**
     * @param value Details about the user's phone number. At most 1 phone number is allowed. Detailed below.
     */
    @JvmName("hsadhcxrjpktsbik")
    public suspend fun phoneNumbers(`value`: Output<UserPhoneNumbersArgs>) {
        this.phoneNumbers = value
    }

    /**
     * @param value The preferred language of the user.
     */
    @JvmName("dltyeigpwomonldm")
    public suspend fun preferredLanguage(`value`: Output<String>) {
        this.preferredLanguage = value
    }

    /**
     * @param value An URL that may be associated with the user.
     */
    @JvmName("vdfwudjjukjpakwk")
    public suspend fun profileUrl(`value`: Output<String>) {
        this.profileUrl = value
    }

    /**
     * @param value The user's time zone.
     */
    @JvmName("vpujoiuqscxnfvij")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value The user's title.
     */
    @JvmName("eybxmoypgqvfywwv")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
     * The following arguments are optional:
     */
    @JvmName("fyybyfjxdcqlkmxe")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The user type.
     */
    @JvmName("frfqkrsevpkbgfem")
    public suspend fun userType(`value`: Output<String>) {
        this.userType = value
    }

    /**
     * @param value Details about the user's address. At most 1 address is allowed. Detailed below.
     */
    @JvmName("ksuxltvafjjrncwb")
    public suspend fun addresses(`value`: UserAddressesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param argument Details about the user's address. At most 1 address is allowed. Detailed below.
     */
    @JvmName("vauwydgnyumhilqh")
    public suspend fun addresses(argument: suspend UserAddressesArgsBuilder.() -> Unit) {
        val toBeMapped = UserAddressesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addresses = mapped
    }

    /**
     * @param value The name that is typically displayed when the user is referenced.
     */
    @JvmName("syufvcbsndmgmbdo")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Details about the user's email. At most 1 email is allowed. Detailed below.
     */
    @JvmName("rnobgxnrtcelexlh")
    public suspend fun emails(`value`: UserEmailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param argument Details about the user's email. At most 1 email is allowed. Detailed below.
     */
    @JvmName("uknjycadocawxpqu")
    public suspend fun emails(argument: suspend UserEmailsArgsBuilder.() -> Unit) {
        val toBeMapped = UserEmailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.emails = mapped
    }

    /**
     * @param value The globally unique identifier for the identity store that this user is in.
     */
    @JvmName("vxmniuwvoyqrdnam")
    public suspend fun identityStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityStoreId = mapped
    }

    /**
     * @param value The user's geographical region or location.
     */
    @JvmName("dhwlbvnefgduoyad")
    public suspend fun locale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value Details about the user's full name. Detailed below.
     */
    @JvmName("ndcbugaxqkcsmbea")
    public suspend fun name(`value`: UserNameArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param argument Details about the user's full name. Detailed below.
     */
    @JvmName("trhulwboxekywefx")
    public suspend fun name(argument: suspend UserNameArgsBuilder.() -> Unit) {
        val toBeMapped = UserNameArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.name = mapped
    }

    /**
     * @param value An alternate name for the user.
     */
    @JvmName("gwnkrnmhujadgdfe")
    public suspend fun nickname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nickname = mapped
    }

    /**
     * @param value Details about the user's phone number. At most 1 phone number is allowed. Detailed below.
     */
    @JvmName("cnhdnjaulmjhnckb")
    public suspend fun phoneNumbers(`value`: UserPhoneNumbersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumbers = mapped
    }

    /**
     * @param argument Details about the user's phone number. At most 1 phone number is allowed. Detailed below.
     */
    @JvmName("isvvjlejpjjmvjos")
    public suspend fun phoneNumbers(argument: suspend UserPhoneNumbersArgsBuilder.() -> Unit) {
        val toBeMapped = UserPhoneNumbersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.phoneNumbers = mapped
    }

    /**
     * @param value The preferred language of the user.
     */
    @JvmName("faihrlbvdbtorqhu")
    public suspend fun preferredLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredLanguage = mapped
    }

    /**
     * @param value An URL that may be associated with the user.
     */
    @JvmName("jxslydrpgfudcfqx")
    public suspend fun profileUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileUrl = mapped
    }

    /**
     * @param value The user's time zone.
     */
    @JvmName("lqwmhyrdionajkxo")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    /**
     * @param value The user's title.
     */
    @JvmName("mfkgenjlnmdtqudh")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value A unique string used to identify the user. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. The limit is 128 characters.
     * The following arguments are optional:
     */
    @JvmName("rcuvatibegkcqkoi")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value The user type.
     */
    @JvmName("vrodxhxuovpxwpwf")
    public suspend fun userType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userType = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        addresses = addresses,
        displayName = displayName,
        emails = emails,
        identityStoreId = identityStoreId,
        locale = locale,
        name = name,
        nickname = nickname,
        phoneNumbers = phoneNumbers,
        preferredLanguage = preferredLanguage,
        profileUrl = profileUrl,
        timezone = timezone,
        title = title,
        userName = userName,
        userType = userType,
    )
}
