@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierExternalId.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The identifier issued to this resource by an external identity provider.
 * @property issuer The issuer for an external identifier.
 */
public data class GetGroupAlternateIdentifierExternalId(
    public val id: String,
    public val issuer: String,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierExternalId> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierExternalId =
        com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifierExternalId.builder()
            .id(id.let({ args0 -> args0 }))
            .issuer(issuer.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupAlternateIdentifierExternalId].
 */
@PulumiTagMarker
public class GetGroupAlternateIdentifierExternalIdBuilder internal constructor() {
    private var id: String? = null

    private var issuer: String? = null

    /**
     * @param value The identifier issued to this resource by an external identity provider.
     */
    @JvmName("yufqwfwtyjvgvvol")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The issuer for an external identifier.
     */
    @JvmName("wbxepolrpaliyegb")
    public suspend fun issuer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.issuer = mapped
    }

    internal fun build(): GetGroupAlternateIdentifierExternalId =
        GetGroupAlternateIdentifierExternalId(
            id = id ?: throw PulumiNullFieldException("id"),
            issuer = issuer ?: throw PulumiNullFieldException("issuer"),
        )
}
