@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetGroupFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attributePath Attribute path that is used to specify which attribute name to search. Currently, `DisplayName` is the only valid attribute path.
 * @property attributeValue Value for an attribute.
 */
public data class GetGroupFilter(
    public val attributePath: String,
    public val attributeValue: String,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetGroupFilter> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetGroupFilter =
        com.pulumi.aws.identitystore.inputs.GetGroupFilter.builder()
            .attributePath(attributePath.let({ args0 -> args0 }))
            .attributeValue(attributeValue.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupFilter].
 */
@PulumiTagMarker
public class GetGroupFilterBuilder internal constructor() {
    private var attributePath: String? = null

    private var attributeValue: String? = null

    /**
     * @param value Attribute path that is used to specify which attribute name to search. Currently, `DisplayName` is the only valid attribute path.
     */
    @JvmName("svgolpmulmvcldmd")
    public suspend fun attributePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attributePath = mapped
    }

    /**
     * @param value Value for an attribute.
     */
    @JvmName("bbxvbgwmrfynibhb")
    public suspend fun attributeValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attributeValue = mapped
    }

    internal fun build(): GetGroupFilter = GetGroupFilter(
        attributePath = attributePath ?: throw PulumiNullFieldException("attributePath"),
        attributeValue = attributeValue ?: throw PulumiNullFieldException("attributeValue"),
    )
}
