@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroups.
 * @property identityStoreId Identity Store ID associated with the Single Sign-On (SSO) Instance.
 */
public data class GetGroupsPlainArgs(
    public val identityStoreId: String,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetGroupsPlainArgs =
        com.pulumi.aws.identitystore.inputs.GetGroupsPlainArgs.builder()
            .identityStoreId(identityStoreId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetGroupsPlainArgsBuilder internal constructor() {
    private var identityStoreId: String? = null

    /**
     * @param value Identity Store ID associated with the Single Sign-On (SSO) Instance.
     */
    @JvmName("uvyibcetiayecbfq")
    public suspend fun identityStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identityStoreId = mapped
    }

    internal fun build(): GetGroupsPlainArgs = GetGroupsPlainArgs(
        identityStoreId = identityStoreId ?: throw PulumiNullFieldException("identityStoreId"),
    )
}
