@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifier.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property externalId Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
 * @property uniqueAttribute An entity attribute that's unique to a specific entity. Detailed below.
 * > Exactly one of the above arguments must be provided.
 */
public data class GetUserAlternateIdentifier(
    public val externalId: GetUserAlternateIdentifierExternalId? = null,
    public val uniqueAttribute: GetUserAlternateIdentifierUniqueAttribute? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifier> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifier =
        com.pulumi.aws.identitystore.inputs.GetUserAlternateIdentifier.builder()
            .externalId(externalId?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uniqueAttribute(uniqueAttribute?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetUserAlternateIdentifier].
 */
@PulumiTagMarker
public class GetUserAlternateIdentifierBuilder internal constructor() {
    private var externalId: GetUserAlternateIdentifierExternalId? = null

    private var uniqueAttribute: GetUserAlternateIdentifierUniqueAttribute? = null

    /**
     * @param value Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
     */
    @JvmName("cjwtklejuheueklk")
    public suspend fun externalId(`value`: GetUserAlternateIdentifierExternalId?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.externalId = mapped
    }

    /**
     * @param argument Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
     */
    @JvmName("dvwfvrhlopavyrwq")
    public suspend fun externalId(argument: suspend GetUserAlternateIdentifierExternalIdBuilder.() -> Unit) {
        val toBeMapped = GetUserAlternateIdentifierExternalIdBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.externalId = mapped
    }

    /**
     * @param value An entity attribute that's unique to a specific entity. Detailed below.
     * > Exactly one of the above arguments must be provided.
     */
    @JvmName("dbvvcfwkuxypjudk")
    public suspend fun uniqueAttribute(`value`: GetUserAlternateIdentifierUniqueAttribute?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.uniqueAttribute = mapped
    }

    /**
     * @param argument An entity attribute that's unique to a specific entity. Detailed below.
     * > Exactly one of the above arguments must be provided.
     */
    @JvmName("nokfllldvfwvxcrm")
    public suspend fun uniqueAttribute(argument: suspend GetUserAlternateIdentifierUniqueAttributeBuilder.() -> Unit) {
        val toBeMapped = GetUserAlternateIdentifierUniqueAttributeBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.uniqueAttribute = mapped
    }

    internal fun build(): GetUserAlternateIdentifier = GetUserAlternateIdentifier(
        externalId = externalId,
        uniqueAttribute = uniqueAttribute,
    )
}
