@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property alternateIdentifier A unique identifier for a user or group that is not the primary identifier. Conflicts with `user_id` and `filter`. Detailed below.
 * @property filter Configuration block for filtering by a unique attribute of the user. Detailed below.
 * @property identityStoreId Identity Store ID associated with the Single Sign-On Instance.
 * The following arguments are optional:
 * @property userId The identifier for a user in the Identity Store.
 * > Exactly one of the above arguments must be provided. Passing both `filter` and `user_id` is allowed for backwards compatibility.
 */
public data class GetUserPlainArgs(
    public val alternateIdentifier: GetUserAlternateIdentifier? = null,
    @Deprecated(
        message = """
  Use the alternate_identifier attribute instead.
  """,
    )
    public val filter: GetUserFilter? = null,
    public val identityStoreId: String,
    public val userId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetUserPlainArgs =
        com.pulumi.aws.identitystore.inputs.GetUserPlainArgs.builder()
            .alternateIdentifier(alternateIdentifier?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityStoreId(identityStoreId.let({ args0 -> args0 }))
            .userId(userId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var alternateIdentifier: GetUserAlternateIdentifier? = null

    private var filter: GetUserFilter? = null

    private var identityStoreId: String? = null

    private var userId: String? = null

    /**
     * @param value A unique identifier for a user or group that is not the primary identifier. Conflicts with `user_id` and `filter`. Detailed below.
     */
    @JvmName("xshejnpoegblfqgf")
    public suspend fun alternateIdentifier(`value`: GetUserAlternateIdentifier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.alternateIdentifier = mapped
    }

    /**
     * @param argument A unique identifier for a user or group that is not the primary identifier. Conflicts with `user_id` and `filter`. Detailed below.
     */
    @JvmName("uptushamqaqthcdt")
    public suspend fun alternateIdentifier(argument: suspend GetUserAlternateIdentifierBuilder.() -> Unit) {
        val toBeMapped = GetUserAlternateIdentifierBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.alternateIdentifier = mapped
    }

    /**
     * @param value Configuration block for filtering by a unique attribute of the user. Detailed below.
     */
    @Deprecated(
        message = """
  Use the alternate_identifier attribute instead.
  """,
    )
    @JvmName("aooophdojsihrkad")
    public suspend fun filter(`value`: GetUserFilter?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param argument Configuration block for filtering by a unique attribute of the user. Detailed below.
     */
    @Deprecated(
        message = """
  Use the alternate_identifier attribute instead.
  """,
    )
    @JvmName("wcvrxufdfauhrwmh")
    public suspend fun filter(argument: suspend GetUserFilterBuilder.() -> Unit) {
        val toBeMapped = GetUserFilterBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.filter = mapped
    }

    /**
     * @param value Identity Store ID associated with the Single Sign-On Instance.
     * The following arguments are optional:
     */
    @JvmName("qrheuogcwajsfnqg")
    public suspend fun identityStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.identityStoreId = mapped
    }

    /**
     * @param value The identifier for a user in the Identity Store.
     * > Exactly one of the above arguments must be provided. Passing both `filter` and `user_id` is allowed for backwards compatibility.
     */
    @JvmName("cfkmocuhaymhgmpo")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userId = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        alternateIdentifier = alternateIdentifier,
        filter = filter,
        identityStoreId = identityStoreId ?: throw PulumiNullFieldException("identityStoreId"),
        userId = userId,
    )
}
