@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.UserAddressesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property country The country that this address is in.
 * @property formatted The name that is typically displayed when the address is shown for display.
 * @property locality The address locality.
 * @property postalCode The postal code of the address.
 * @property primary When `true`, this is the primary address associated with the user.
 * @property region The region of the address.
 * @property streetAddress The street of the address.
 * @property type The type of address.
 */
public data class UserAddressesArgs(
    public val country: Output<String>? = null,
    public val formatted: Output<String>? = null,
    public val locality: Output<String>? = null,
    public val postalCode: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
    public val region: Output<String>? = null,
    public val streetAddress: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.UserAddressesArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.UserAddressesArgs =
        com.pulumi.aws.identitystore.inputs.UserAddressesArgs.builder()
            .country(country?.applyValue({ args0 -> args0 }))
            .formatted(formatted?.applyValue({ args0 -> args0 }))
            .locality(locality?.applyValue({ args0 -> args0 }))
            .postalCode(postalCode?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .streetAddress(streetAddress?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAddressesArgs].
 */
@PulumiTagMarker
public class UserAddressesArgsBuilder internal constructor() {
    private var country: Output<String>? = null

    private var formatted: Output<String>? = null

    private var locality: Output<String>? = null

    private var postalCode: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var region: Output<String>? = null

    private var streetAddress: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The country that this address is in.
     */
    @JvmName("qsdqvdygthyflale")
    public suspend fun country(`value`: Output<String>) {
        this.country = value
    }

    /**
     * @param value The name that is typically displayed when the address is shown for display.
     */
    @JvmName("wawtefabtjcxwjmu")
    public suspend fun formatted(`value`: Output<String>) {
        this.formatted = value
    }

    /**
     * @param value The address locality.
     */
    @JvmName("xwymgjryqtvstraj")
    public suspend fun locality(`value`: Output<String>) {
        this.locality = value
    }

    /**
     * @param value The postal code of the address.
     */
    @JvmName("jooyfwtmklmlgeiq")
    public suspend fun postalCode(`value`: Output<String>) {
        this.postalCode = value
    }

    /**
     * @param value When `true`, this is the primary address associated with the user.
     */
    @JvmName("coiyfqstaeirgved")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The region of the address.
     */
    @JvmName("xjqkbqlxndpixnrt")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The street of the address.
     */
    @JvmName("jtdjfsgdyvdpaxjy")
    public suspend fun streetAddress(`value`: Output<String>) {
        this.streetAddress = value
    }

    /**
     * @param value The type of address.
     */
    @JvmName("ggkdpvyqfqiwhite")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The country that this address is in.
     */
    @JvmName("eivndbjtrkxvmumx")
    public suspend fun country(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.country = mapped
    }

    /**
     * @param value The name that is typically displayed when the address is shown for display.
     */
    @JvmName("wxprdejshorgmlhc")
    public suspend fun formatted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatted = mapped
    }

    /**
     * @param value The address locality.
     */
    @JvmName("llpruywobimvtbjs")
    public suspend fun locality(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locality = mapped
    }

    /**
     * @param value The postal code of the address.
     */
    @JvmName("cddtdwmatrfsrwey")
    public suspend fun postalCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postalCode = mapped
    }

    /**
     * @param value When `true`, this is the primary address associated with the user.
     */
    @JvmName("hickonpujayienyl")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The region of the address.
     */
    @JvmName("rmatfouxfbhmqmah")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The street of the address.
     */
    @JvmName("uhvoywsgldmrtbbc")
    public suspend fun streetAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streetAddress = mapped
    }

    /**
     * @param value The type of address.
     */
    @JvmName("wujavogbaepalcfl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): UserAddressesArgs = UserAddressesArgs(
        country = country,
        formatted = formatted,
        locality = locality,
        postalCode = postalCode,
        primary = primary,
        region = region,
        streetAddress = streetAddress,
        type = type,
    )
}
