@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.UserNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property familyName The family name of the user.
 * @property formatted The name that is typically displayed when the name is shown for display.
 * @property givenName The given name of the user.
 * The following arguments are optional:
 * @property honorificPrefix The honorific prefix of the user.
 * @property honorificSuffix The honorific suffix of the user.
 * @property middleName The middle name of the user.
 */
public data class UserNameArgs(
    public val familyName: Output<String>,
    public val formatted: Output<String>? = null,
    public val givenName: Output<String>,
    public val honorificPrefix: Output<String>? = null,
    public val honorificSuffix: Output<String>? = null,
    public val middleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.UserNameArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.UserNameArgs =
        com.pulumi.aws.identitystore.inputs.UserNameArgs.builder()
            .familyName(familyName.applyValue({ args0 -> args0 }))
            .formatted(formatted?.applyValue({ args0 -> args0 }))
            .givenName(givenName.applyValue({ args0 -> args0 }))
            .honorificPrefix(honorificPrefix?.applyValue({ args0 -> args0 }))
            .honorificSuffix(honorificSuffix?.applyValue({ args0 -> args0 }))
            .middleName(middleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserNameArgs].
 */
@PulumiTagMarker
public class UserNameArgsBuilder internal constructor() {
    private var familyName: Output<String>? = null

    private var formatted: Output<String>? = null

    private var givenName: Output<String>? = null

    private var honorificPrefix: Output<String>? = null

    private var honorificSuffix: Output<String>? = null

    private var middleName: Output<String>? = null

    /**
     * @param value The family name of the user.
     */
    @JvmName("hnedbseecxifyess")
    public suspend fun familyName(`value`: Output<String>) {
        this.familyName = value
    }

    /**
     * @param value The name that is typically displayed when the name is shown for display.
     */
    @JvmName("lvrdfkvgdldiordm")
    public suspend fun formatted(`value`: Output<String>) {
        this.formatted = value
    }

    /**
     * @param value The given name of the user.
     * The following arguments are optional:
     */
    @JvmName("yejxmtrrwrabkdfn")
    public suspend fun givenName(`value`: Output<String>) {
        this.givenName = value
    }

    /**
     * @param value The honorific prefix of the user.
     */
    @JvmName("dkjimsoqfrbkmgou")
    public suspend fun honorificPrefix(`value`: Output<String>) {
        this.honorificPrefix = value
    }

    /**
     * @param value The honorific suffix of the user.
     */
    @JvmName("hpoyyjjakjxvbxbm")
    public suspend fun honorificSuffix(`value`: Output<String>) {
        this.honorificSuffix = value
    }

    /**
     * @param value The middle name of the user.
     */
    @JvmName("xajmojbrnqkgkvgw")
    public suspend fun middleName(`value`: Output<String>) {
        this.middleName = value
    }

    /**
     * @param value The family name of the user.
     */
    @JvmName("tcgtfsrvcmlgehwv")
    public suspend fun familyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.familyName = mapped
    }

    /**
     * @param value The name that is typically displayed when the name is shown for display.
     */
    @JvmName("arvrdsosmkgnbisx")
    public suspend fun formatted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.formatted = mapped
    }

    /**
     * @param value The given name of the user.
     * The following arguments are optional:
     */
    @JvmName("itrvjhgnchojrghf")
    public suspend fun givenName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.givenName = mapped
    }

    /**
     * @param value The honorific prefix of the user.
     */
    @JvmName("wqpkcdospwvwenqr")
    public suspend fun honorificPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honorificPrefix = mapped
    }

    /**
     * @param value The honorific suffix of the user.
     */
    @JvmName("gdagjjrxqctholvl")
    public suspend fun honorificSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honorificSuffix = mapped
    }

    /**
     * @param value The middle name of the user.
     */
    @JvmName("fjfkqqeaoarfukbd")
    public suspend fun middleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.middleName = mapped
    }

    internal fun build(): UserNameArgs = UserNameArgs(
        familyName = familyName ?: throw PulumiNullFieldException("familyName"),
        formatted = formatted,
        givenName = givenName ?: throw PulumiNullFieldException("givenName"),
        honorificPrefix = honorificPrefix,
        honorificSuffix = honorificSuffix,
        middleName = middleName,
    )
}
