@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributePath Attribute path that is used to specify which attribute name to search. Currently, `DisplayName` is the only valid attribute path.
 * @property attributeValue Value for an attribute.
 */
public data class GetGroupFilter(
    public val attributePath: String,
    public val attributeValue: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupFilter): GetGroupFilter = GetGroupFilter(
            attributePath = javaType.attributePath(),
            attributeValue = javaType.attributeValue(),
        )
    }
}
