@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description Description of the specified group.
 * @property displayName Group's display name.
 * @property externalIds List of identifiers issued to this resource by an external identity provider.
 * @property groupId Identifier of the group in the Identity Store.
 * @property identityStoreId Identity Store ID associated with the Single Sign-On (SSO) Instance.
 */
public data class GetGroupsGroup(
    public val description: String,
    public val displayName: String,
    public val externalIds: List<GetGroupsGroupExternalId>,
    public val groupId: String,
    public val identityStoreId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupsGroup): GetGroupsGroup = GetGroupsGroup(
            description = javaType.description(),
            displayName = javaType.displayName(),
            externalIds = javaType.externalIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupsGroupExternalId.Companion.toKotlin(args0)
                })
            }),
            groupId = javaType.groupId(),
            identityStoreId = javaType.identityStoreId(),
        )
    }
}
