@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id Identifier issued to this resource by an external identity provider.
 * @property issuer Issuer for an external identifier.
 */
public data class GetGroupsGroupExternalId(
    public val id: String,
    public val issuer: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupsGroupExternalId): GetGroupsGroupExternalId = GetGroupsGroupExternalId(
            id = javaType.id(),
            issuer = javaType.issuer(),
        )
    }
}
