@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroups.
 * @property groups List of Identity Store Groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityStoreId
 */
public data class GetGroupsResult(
    public val groups: List<GetGroupsGroup>,
    public val id: String,
    public val identityStoreId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupsResult): GetGroupsResult = GetGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            identityStoreId = javaType.identityStoreId(),
        )
    }
}
