@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property externalId Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
 * @property uniqueAttribute An entity attribute that's unique to a specific entity. Detailed below.
 * > Exactly one of the above arguments must be provided.
 */
public data class GetUserAlternateIdentifier(
    public val externalId: GetUserAlternateIdentifierExternalId? = null,
    public val uniqueAttribute: GetUserAlternateIdentifierUniqueAttribute? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetUserAlternateIdentifier): GetUserAlternateIdentifier = GetUserAlternateIdentifier(
            externalId = javaType.externalId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserAlternateIdentifierExternalId.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uniqueAttribute = javaType.uniqueAttribute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserAlternateIdentifierUniqueAttribute.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
