@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property familyName The family name of the user.
 * @property formatted The name that is typically displayed when the name is shown for display.
 * @property givenName The given name of the user.
 * @property honorificPrefix The honorific prefix of the user.
 * @property honorificSuffix The honorific suffix of the user.
 * @property middleName The middle name of the user.
 */
public data class GetUserName(
    public val familyName: String,
    public val formatted: String,
    public val givenName: String,
    public val honorificPrefix: String,
    public val honorificSuffix: String,
    public val middleName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetUserName): GetUserName =
            GetUserName(
                familyName = javaType.familyName(),
                formatted = javaType.formatted(),
                givenName = javaType.givenName(),
                honorificPrefix = javaType.honorificPrefix(),
                honorificSuffix = javaType.honorificSuffix(),
                middleName = javaType.middleName(),
            )
    }
}
