@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUser.
 * @property addresses List of details about the user's address.
 * @property alternateIdentifier
 * @property displayName The name that is typically displayed when the user is referenced.
 * @property emails List of details about the user's email.
 * @property externalIds List of identifiers issued to this resource by an external identity provider.
 * @property filter
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityStoreId
 * @property locale The user's geographical region or location.
 * @property names Details about the user's full name.
 * @property nickname An alternate name for the user.
 * @property phoneNumbers List of details about the user's phone number.
 * @property preferredLanguage The preferred language of the user.
 * @property profileUrl An URL that may be associated with the user.
 * @property timezone The user's time zone.
 * @property title The user's title.
 * @property userId
 * @property userName User's user name value.
 * @property userType The user type.
 */
public data class GetUserResult(
    public val addresses: List<GetUserAddress>,
    public val alternateIdentifier: GetUserAlternateIdentifier? = null,
    public val displayName: String,
    public val emails: List<GetUserEmail>,
    public val externalIds: List<GetUserExternalId>,
    @Deprecated(
        message = """
  Use the alternate_identifier attribute instead.
  """,
    )
    public val filter: GetUserFilter? = null,
    public val id: String,
    public val identityStoreId: String,
    public val locale: String,
    public val names: List<GetUserName>,
    public val nickname: String,
    public val phoneNumbers: List<GetUserPhoneNumber>,
    public val preferredLanguage: String,
    public val profileUrl: String,
    public val timezone: String,
    public val title: String,
    public val userId: String,
    public val userName: String,
    public val userType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetUserResult): GetUserResult = GetUserResult(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserAddress.Companion.toKotlin(args0)
                })
            }),
            alternateIdentifier = javaType.alternateIdentifier().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserAlternateIdentifier.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName(),
            emails = javaType.emails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserEmail.Companion.toKotlin(args0)
                })
            }),
            externalIds = javaType.externalIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserExternalId.Companion.toKotlin(args0)
                })
            }),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identityStoreId = javaType.identityStoreId(),
            locale = javaType.locale(),
            names = javaType.names().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserName.Companion.toKotlin(args0)
                })
            }),
            nickname = javaType.nickname(),
            phoneNumbers = javaType.phoneNumbers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetUserPhoneNumber.Companion.toKotlin(args0)
                })
            }),
            preferredLanguage = javaType.preferredLanguage(),
            profileUrl = javaType.profileUrl(),
            timezone = javaType.timezone(),
            title = javaType.title(),
            userId = javaType.userId(),
            userName = javaType.userName(),
            userType = javaType.userType(),
        )
    }
}
