@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The identifier issued to this resource by an external identity provider.
 * @property issuer The issuer for an external identifier.
 */
public data class GroupExternalId(
    public val id: String? = null,
    public val issuer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GroupExternalId): GroupExternalId = GroupExternalId(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
