@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Component.
 * ## Example Usage
 * ### URI Document
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.Component("example", {
 *     name: "example",
 *     platform: "Linux",
 *     uri: `s3://${exampleAwsS3Object.bucket}/${exampleAwsS3Object.key}`,
 *     version: "1.0.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.Component("example",
 *     name="example",
 *     platform="Linux",
 *     uri=f"s3://{example_aws_s3_object['bucket']}/{example_aws_s3_object['key']}",
 *     version="1.0.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.Component("example", new()
 *     {
 *         Name = "example",
 *         Platform = "Linux",
 *         Uri = $"s3://{exampleAwsS3Object.Bucket}/{exampleAwsS3Object.Key}",
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewComponent(ctx, "example", &imagebuilder.ComponentArgs{
 * 			Name:     pulumi.String("example"),
 * 			Platform: pulumi.String("Linux"),
 * 			Uri:      pulumi.Sprintf("s3://%v/%v", exampleAwsS3Object.Bucket, exampleAwsS3Object.Key),
 * 			Version:  pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Component;
 * import com.pulumi.aws.imagebuilder.ComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Component("example", ComponentArgs.builder()
 *             .name("example")
 *             .platform("Linux")
 *             .uri(String.format("s3://%s/%s", exampleAwsS3Object.bucket(),exampleAwsS3Object.key()))
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:Component
 *     properties:
 *       name: example
 *       platform: Linux
 *       uri: s3://${exampleAwsS3Object.bucket}/${exampleAwsS3Object.key}
 *       version: 1.0.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_components` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/component:Component example arn:aws:imagebuilder:us-east-1:123456789012:component/example/1.0.0/1
 * ```
 * Certain resource arguments, such as `uri`, cannot be read via the API and imported into the provider. The provider will display a difference for these arguments the first run after import if declared in the the provider configuration for an imported resource.
 * @property changeDescription Change description of the component.
 * @property data Inline YAML string with data of the component. Exactly one of `data` and `uri` can be specified. the provider will only perform drift detection of its value when present in a configuration.
 * @property description Description of the component.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the component.
 * @property name Name of the component.
 * @property platform Platform of the component.
 * @property skipDestroy Whether to retain the old version when the resource is destroyed or replacement is necessary. Defaults to `false`.
 * @property supportedOsVersions Set of Operating Systems (OS) supported by the component.
 * @property tags Key-value map of resource tags for the component. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property uri S3 URI with data of the component. Exactly one of `data` and `uri` can be specified.
 * > **NOTE:** Updating `data` or `uri` requires specifying a new `version`. This causes replacement of the resource. The `skip_destroy` argument can be used to retain the old version.
 * @property version Version of the component.
 * The following attributes are optional:
 */
public data class ComponentArgs(
    public val changeDescription: Output<String>? = null,
    public val `data`: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val platform: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val supportedOsVersions: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uri: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ComponentArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ComponentArgs =
        com.pulumi.aws.imagebuilder.ComponentArgs.builder()
            .changeDescription(changeDescription?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .platform(platform?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .supportedOsVersions(supportedOsVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uri(uri?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComponentArgs].
 */
@PulumiTagMarker
public class ComponentArgsBuilder internal constructor() {
    private var changeDescription: Output<String>? = null

    private var `data`: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var platform: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var supportedOsVersions: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uri: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Change description of the component.
     */
    @JvmName("erjbtgwuprshxkod")
    public suspend fun changeDescription(`value`: Output<String>) {
        this.changeDescription = value
    }

    /**
     * @param value Inline YAML string with data of the component. Exactly one of `data` and `uri` can be specified. the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("acoajysmkxmiiftm")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Description of the component.
     */
    @JvmName("ipoapgjuqsdnkohs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the component.
     */
    @JvmName("ifbdxrtmyiengmjt")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the component.
     */
    @JvmName("xtwbonjelpbosxxy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Platform of the component.
     */
    @JvmName("scjppwbnkodtkjfb")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Whether to retain the old version when the resource is destroyed or replacement is necessary. Defaults to `false`.
     */
    @JvmName("nhwikstgamorgiha")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Set of Operating Systems (OS) supported by the component.
     */
    @JvmName("wfvtcgogmwupllew")
    public suspend fun supportedOsVersions(`value`: Output<List<String>>) {
        this.supportedOsVersions = value
    }

    @JvmName("lmdokrthixjlvoux")
    public suspend fun supportedOsVersions(vararg values: Output<String>) {
        this.supportedOsVersions = Output.all(values.asList())
    }

    /**
     * @param values Set of Operating Systems (OS) supported by the component.
     */
    @JvmName("xhoivfqwaqoidyws")
    public suspend fun supportedOsVersions(values: List<Output<String>>) {
        this.supportedOsVersions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags for the component. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("poyujmqtnhjuyboc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value S3 URI with data of the component. Exactly one of `data` and `uri` can be specified.
     * > **NOTE:** Updating `data` or `uri` requires specifying a new `version`. This causes replacement of the resource. The `skip_destroy` argument can be used to retain the old version.
     */
    @JvmName("ddaafcurlqfvcfte")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Version of the component.
     * The following attributes are optional:
     */
    @JvmName("utqlekjyxphnmbbk")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Change description of the component.
     */
    @JvmName("yandmroxuurtjlho")
    public suspend fun changeDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeDescription = mapped
    }

    /**
     * @param value Inline YAML string with data of the component. Exactly one of `data` and `uri` can be specified. the provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("qteusvyqmbnydsog")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Description of the component.
     */
    @JvmName("qilltutegqwdajna")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the component.
     */
    @JvmName("lkhnltdyicudsemk")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the component.
     */
    @JvmName("fuyaeioejvndvmdh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Platform of the component.
     */
    @JvmName("qmktsfwdyhwyynmy")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Whether to retain the old version when the resource is destroyed or replacement is necessary. Defaults to `false`.
     */
    @JvmName("fgptswanodkspudp")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Set of Operating Systems (OS) supported by the component.
     */
    @JvmName("ocdotdtbomcmccfh")
    public suspend fun supportedOsVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedOsVersions = mapped
    }

    /**
     * @param values Set of Operating Systems (OS) supported by the component.
     */
    @JvmName("cpocmwwfdtjxoamj")
    public suspend fun supportedOsVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportedOsVersions = mapped
    }

    /**
     * @param value Key-value map of resource tags for the component. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jabxxkxaskiyyybk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the component. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("syxqpsqyrrhvlrmp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value S3 URI with data of the component. Exactly one of `data` and `uri` can be specified.
     * > **NOTE:** Updating `data` or `uri` requires specifying a new `version`. This causes replacement of the resource. The `skip_destroy` argument can be used to retain the old version.
     */
    @JvmName("mhvqobiyjcmafnnf")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Version of the component.
     * The following attributes are optional:
     */
    @JvmName("mdpapmejrlgedwio")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ComponentArgs = ComponentArgs(
        changeDescription = changeDescription,
        `data` = `data`,
        description = description,
        kmsKeyId = kmsKeyId,
        name = name,
        platform = platform,
        skipDestroy = skipDestroy,
        supportedOsVersions = supportedOsVersions,
        tags = tags,
        uri = uri,
        version = version,
    )
}
