@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.DistributionConfigurationArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.DistributionConfigurationDistributionArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.DistributionConfigurationDistributionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Distribution Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.DistributionConfiguration("example", {
 *     name: "example",
 *     distributions: [{
 *         amiDistributionConfiguration: {
 *             amiTags: {
 *                 CostCenter: "IT",
 *             },
 *             name: "example-{{ imagebuilder:buildDate }}",
 *             launchPermission: {
 *                 userIds: ["123456789012"],
 *             },
 *         },
 *         launchTemplateConfigurations: [{
 *             launchTemplateId: "lt-0aaa1bcde2ff3456",
 *         }],
 *         region: "us-east-1",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.DistributionConfiguration("example",
 *     name="example",
 *     distributions=[{
 *         "ami_distribution_configuration": {
 *             "ami_tags": {
 *                 "cost_center": "IT",
 *             },
 *             "name": "example-{{ imagebuilder:buildDate }}",
 *             "launch_permission": {
 *                 "user_ids": ["123456789012"],
 *             },
 *         },
 *         "launch_template_configurations": [{
 *             "launch_template_id": "lt-0aaa1bcde2ff3456",
 *         }],
 *         "region": "us-east-1",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.DistributionConfiguration("example", new()
 *     {
 *         Name = "example",
 *         Distributions = new[]
 *         {
 *             new Aws.ImageBuilder.Inputs.DistributionConfigurationDistributionArgs
 *             {
 *                 AmiDistributionConfiguration = new Aws.ImageBuilder.Inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs
 *                 {
 *                     AmiTags =
 *                     {
 *                         { "CostCenter", "IT" },
 *                     },
 *                     Name = "example-{{ imagebuilder:buildDate }}",
 *                     LaunchPermission = new Aws.ImageBuilder.Inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs
 *                     {
 *                         UserIds = new[]
 *                         {
 *                             "123456789012",
 *                         },
 *                     },
 *                 },
 *                 LaunchTemplateConfigurations = new[]
 *                 {
 *                     new Aws.ImageBuilder.Inputs.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs
 *                     {
 *                         LaunchTemplateId = "lt-0aaa1bcde2ff3456",
 *                     },
 *                 },
 *                 Region = "us-east-1",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewDistributionConfiguration(ctx, "example", &imagebuilder.DistributionConfigurationArgs{
 * 			Name: pulumi.String("example"),
 * 			Distributions: imagebuilder.DistributionConfigurationDistributionArray{
 * 				&imagebuilder.DistributionConfigurationDistributionArgs{
 * 					AmiDistributionConfiguration: &imagebuilder.DistributionConfigurationDistributionAmiDistributionConfigurationArgs{
 * 						AmiTags: pulumi.StringMap{
 * 							"CostCenter": pulumi.String("IT"),
 * 						},
 * 						Name: pulumi.String("example-{{ imagebuilder:buildDate }}"),
 * 						LaunchPermission: &imagebuilder.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs{
 * 							UserIds: pulumi.StringArray{
 * 								pulumi.String("123456789012"),
 * 							},
 * 						},
 * 					},
 * 					LaunchTemplateConfigurations: imagebuilder.DistributionConfigurationDistributionLaunchTemplateConfigurationArray{
 * 						&imagebuilder.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs{
 * 							LaunchTemplateId: pulumi.String("lt-0aaa1bcde2ff3456"),
 * 						},
 * 					},
 * 					Region: pulumi.String("us-east-1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.DistributionConfiguration;
 * import com.pulumi.aws.imagebuilder.DistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DistributionConfiguration("example", DistributionConfigurationArgs.builder()
 *             .name("example")
 *             .distributions(DistributionConfigurationDistributionArgs.builder()
 *                 .amiDistributionConfiguration(DistributionConfigurationDistributionAmiDistributionConfigurationArgs.builder()
 *                     .amiTags(Map.of("CostCenter", "IT"))
 *                     .name("example-{{ imagebuilder:buildDate }}")
 *                     .launchPermission(DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs.builder()
 *                         .userIds("123456789012")
 *                         .build())
 *                     .build())
 *                 .launchTemplateConfigurations(DistributionConfigurationDistributionLaunchTemplateConfigurationArgs.builder()
 *                     .launchTemplateId("lt-0aaa1bcde2ff3456")
 *                     .build())
 *                 .region("us-east-1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:DistributionConfiguration
 *     properties:
 *       name: example
 *       distributions:
 *         - amiDistributionConfiguration:
 *             amiTags:
 *               CostCenter: IT
 *             name: example-{{ imagebuilder:buildDate }}
 *             launchPermission:
 *               userIds:
 *                 - '123456789012'
 *           launchTemplateConfigurations:
 *             - launchTemplateId: lt-0aaa1bcde2ff3456
 *           region: us-east-1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_distribution_configurations` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/distributionConfiguration:DistributionConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:distribution-configuration/example
 * ```
 * @property description Description of the distribution configuration.
 * @property distributions One or more configuration blocks with distribution settings. Detailed below.
 * The following arguments are optional:
 * @property name Name of the distribution configuration.
 * @property tags Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DistributionConfigurationArgs(
    public val description: Output<String>? = null,
    public val distributions: Output<List<DistributionConfigurationDistributionArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.DistributionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.DistributionConfigurationArgs =
        com.pulumi.aws.imagebuilder.DistributionConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .distributions(
                distributions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DistributionConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var distributions: Output<List<DistributionConfigurationDistributionArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the distribution configuration.
     */
    @JvmName("qmkrjrkhgkwqlrhc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("wwfdmlspbdkpeero")
    public suspend fun distributions(`value`: Output<List<DistributionConfigurationDistributionArgs>>) {
        this.distributions = value
    }

    @JvmName("prtmgkfkhnodepdm")
    public suspend fun distributions(vararg values: Output<DistributionConfigurationDistributionArgs>) {
        this.distributions = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("dhyqrrdidhfrrxop")
    public suspend fun distributions(values: List<Output<DistributionConfigurationDistributionArgs>>) {
        this.distributions = Output.all(values)
    }

    /**
     * @param value Name of the distribution configuration.
     */
    @JvmName("agreowkerfalprvf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rkjvfewgiqlhhvho")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the distribution configuration.
     */
    @JvmName("gdrppfvycysdrets")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("eaoqswgfkodsstap")
    public suspend fun distributions(`value`: List<DistributionConfigurationDistributionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("fvyeurvuikgslfjh")
    public suspend fun distributions(argument: List<suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("wvaqpwiiyryxcnpm")
    public suspend fun distributions(vararg argument: suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("yqcqpxyqdfshlgtf")
    public suspend fun distributions(argument: suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionConfigurationDistributionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param values One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("jlljwesbujiajenj")
    public suspend fun distributions(vararg values: DistributionConfigurationDistributionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributions = mapped
    }

    /**
     * @param value Name of the distribution configuration.
     */
    @JvmName("gdlsktamvubfrbqy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ljxptvibbxqleowe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pylodlgjchkwltdo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DistributionConfigurationArgs = DistributionConfigurationArgs(
        description = description,
        distributions = distributions,
        name = name,
        tags = tags,
    )
}
