@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageImageScanningConfiguration
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageImageTestsConfiguration
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageOutputResource
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageWorkflow
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageImageScanningConfiguration.Companion.toKotlin as imageImageScanningConfigurationToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageImageTestsConfiguration.Companion.toKotlin as imageImageTestsConfigurationToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageOutputResource.Companion.toKotlin as imageOutputResourceToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImageWorkflow.Companion.toKotlin as imageWorkflowToKotlin

/**
 * Builder for [Image].
 */
@PulumiTagMarker
public class ImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageArgs = ImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageArgsBuilder.() -> Unit) {
        val builder = ImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Image {
        val builtJavaResource = com.pulumi.aws.imagebuilder.Image(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Image(builtJavaResource)
    }
}

/**
 * Manages an Image Builder Image.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.Image("example", {
 *     distributionConfigurationArn: exampleAwsImagebuilderDistributionConfiguration.arn,
 *     imageRecipeArn: exampleAwsImagebuilderImageRecipe.arn,
 *     infrastructureConfigurationArn: exampleAwsImagebuilderInfrastructureConfiguration.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.Image("example",
 *     distribution_configuration_arn=example_aws_imagebuilder_distribution_configuration["arn"],
 *     image_recipe_arn=example_aws_imagebuilder_image_recipe["arn"],
 *     infrastructure_configuration_arn=example_aws_imagebuilder_infrastructure_configuration["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.Image("example", new()
 *     {
 *         DistributionConfigurationArn = exampleAwsImagebuilderDistributionConfiguration.Arn,
 *         ImageRecipeArn = exampleAwsImagebuilderImageRecipe.Arn,
 *         InfrastructureConfigurationArn = exampleAwsImagebuilderInfrastructureConfiguration.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewImage(ctx, "example", &imagebuilder.ImageArgs{
 * 			DistributionConfigurationArn:   pulumi.Any(exampleAwsImagebuilderDistributionConfiguration.Arn),
 * 			ImageRecipeArn:                 pulumi.Any(exampleAwsImagebuilderImageRecipe.Arn),
 * 			InfrastructureConfigurationArn: pulumi.Any(exampleAwsImagebuilderInfrastructureConfiguration.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Image;
 * import com.pulumi.aws.imagebuilder.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Image("example", ImageArgs.builder()
 *             .distributionConfigurationArn(exampleAwsImagebuilderDistributionConfiguration.arn())
 *             .imageRecipeArn(exampleAwsImagebuilderImageRecipe.arn())
 *             .infrastructureConfigurationArn(exampleAwsImagebuilderInfrastructureConfiguration.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:Image
 *     properties:
 *       distributionConfigurationArn: ${exampleAwsImagebuilderDistributionConfiguration.arn}
 *       imageRecipeArn: ${exampleAwsImagebuilderImageRecipe.arn}
 *       infrastructureConfigurationArn: ${exampleAwsImagebuilderInfrastructureConfiguration.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/image:Image example arn:aws:imagebuilder:us-east-1:123456789012:image/example/1.0.0/1
 * ```
 */
public class Image internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.Image,
) : KotlinCustomResource(javaResource, ImageMapper) {
    /**
     * Amazon Resource Name (ARN) of the image.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the container recipe.
     */
    public val containerRecipeArn: Output<String>?
        get() = javaResource.containerRecipeArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date the image was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    public val distributionConfigurationArn: Output<String>?
        get() = javaResource.distributionConfigurationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether additional information about the image being created is collected. Defaults to `true`.
     */
    public val enhancedImageMetadataEnabled: Output<Boolean>?
        get() = javaResource.enhancedImageMetadataEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
     */
    public val executionRole: Output<String>
        get() = javaResource.executionRole().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the image recipe.
     */
    public val imageRecipeArn: Output<String>?
        get() = javaResource.imageRecipeArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block with image scanning configuration. Detailed below.
     */
    public val imageScanningConfiguration: Output<ImageImageScanningConfiguration>
        get() = javaResource.imageScanningConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                imageImageScanningConfigurationToKotlin(args0)
            })
        })

    /**
     * Configuration block with image tests configuration. Detailed below.
     */
    public val imageTestsConfiguration: Output<ImageImageTestsConfiguration>
        get() = javaResource.imageTestsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                imageImageTestsConfigurationToKotlin(args0)
            })
        })

    /**
     * Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     * The following arguments are optional:
     */
    public val infrastructureConfigurationArn: Output<String>
        get() = javaResource.infrastructureConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * Name of the AMI.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating System version of the image.
     */
    public val osVersion: Output<String>
        get() = javaResource.osVersion().applyValue({ args0 -> args0 })

    /**
     * List of objects with resources created by the image.
     */
    public val outputResources: Output<List<ImageOutputResource>>
        get() = javaResource.outputResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> imageOutputResourceToKotlin(args0) })
            })
        })

    /**
     * Platform of the image.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Version of the image.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * Configuration block with the workflow configuration. Detailed below.
     */
    public val workflows: Output<List<ImageWorkflow>>
        get() = javaResource.workflows().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imageWorkflowToKotlin(args0)
                })
            })
        })
}

public object ImageMapper : ResourceMapper<Image> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.Image::class == javaResource::class

    override fun map(javaResource: Resource): Image = Image(
        javaResource as
            com.pulumi.aws.imagebuilder.Image,
    )
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Image].
 */
public suspend fun image(name: String, block: suspend ImageResourceBuilder.() -> Unit): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 */
public fun image(name: String): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
