@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImageArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageScanningConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageScanningConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageTestsConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageTestsConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageWorkflowArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageWorkflowArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Image.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.Image("example", {
 *     distributionConfigurationArn: exampleAwsImagebuilderDistributionConfiguration.arn,
 *     imageRecipeArn: exampleAwsImagebuilderImageRecipe.arn,
 *     infrastructureConfigurationArn: exampleAwsImagebuilderInfrastructureConfiguration.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.Image("example",
 *     distribution_configuration_arn=example_aws_imagebuilder_distribution_configuration["arn"],
 *     image_recipe_arn=example_aws_imagebuilder_image_recipe["arn"],
 *     infrastructure_configuration_arn=example_aws_imagebuilder_infrastructure_configuration["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.Image("example", new()
 *     {
 *         DistributionConfigurationArn = exampleAwsImagebuilderDistributionConfiguration.Arn,
 *         ImageRecipeArn = exampleAwsImagebuilderImageRecipe.Arn,
 *         InfrastructureConfigurationArn = exampleAwsImagebuilderInfrastructureConfiguration.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewImage(ctx, "example", &imagebuilder.ImageArgs{
 * 			DistributionConfigurationArn:   pulumi.Any(exampleAwsImagebuilderDistributionConfiguration.Arn),
 * 			ImageRecipeArn:                 pulumi.Any(exampleAwsImagebuilderImageRecipe.Arn),
 * 			InfrastructureConfigurationArn: pulumi.Any(exampleAwsImagebuilderInfrastructureConfiguration.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Image;
 * import com.pulumi.aws.imagebuilder.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Image("example", ImageArgs.builder()
 *             .distributionConfigurationArn(exampleAwsImagebuilderDistributionConfiguration.arn())
 *             .imageRecipeArn(exampleAwsImagebuilderImageRecipe.arn())
 *             .infrastructureConfigurationArn(exampleAwsImagebuilderInfrastructureConfiguration.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:Image
 *     properties:
 *       distributionConfigurationArn: ${exampleAwsImagebuilderDistributionConfiguration.arn}
 *       imageRecipeArn: ${exampleAwsImagebuilderImageRecipe.arn}
 *       infrastructureConfigurationArn: ${exampleAwsImagebuilderInfrastructureConfiguration.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/image:Image example arn:aws:imagebuilder:us-east-1:123456789012:image/example/1.0.0/1
 * ```
 * @property containerRecipeArn Amazon Resource Name (ARN) of the container recipe.
 * @property distributionConfigurationArn Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected. Defaults to `true`.
 * @property executionRole Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
 * @property imageRecipeArn Amazon Resource Name (ARN) of the image recipe.
 * @property imageScanningConfiguration Configuration block with image scanning configuration. Detailed below.
 * @property imageTestsConfiguration Configuration block with image tests configuration. Detailed below.
 * @property infrastructureConfigurationArn Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workflows Configuration block with the workflow configuration. Detailed below.
 */
public data class ImageArgs(
    public val containerRecipeArn: Output<String>? = null,
    public val distributionConfigurationArn: Output<String>? = null,
    public val enhancedImageMetadataEnabled: Output<Boolean>? = null,
    public val executionRole: Output<String>? = null,
    public val imageRecipeArn: Output<String>? = null,
    public val imageScanningConfiguration: Output<ImageImageScanningConfigurationArgs>? = null,
    public val imageTestsConfiguration: Output<ImageImageTestsConfigurationArgs>? = null,
    public val infrastructureConfigurationArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workflows: Output<List<ImageWorkflowArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ImageArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ImageArgs =
        com.pulumi.aws.imagebuilder.ImageArgs.builder()
            .containerRecipeArn(containerRecipeArn?.applyValue({ args0 -> args0 }))
            .distributionConfigurationArn(distributionConfigurationArn?.applyValue({ args0 -> args0 }))
            .enhancedImageMetadataEnabled(enhancedImageMetadataEnabled?.applyValue({ args0 -> args0 }))
            .executionRole(executionRole?.applyValue({ args0 -> args0 }))
            .imageRecipeArn(imageRecipeArn?.applyValue({ args0 -> args0 }))
            .imageScanningConfiguration(
                imageScanningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageTestsConfiguration(
                imageTestsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .infrastructureConfigurationArn(infrastructureConfigurationArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workflows(
                workflows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var containerRecipeArn: Output<String>? = null

    private var distributionConfigurationArn: Output<String>? = null

    private var enhancedImageMetadataEnabled: Output<Boolean>? = null

    private var executionRole: Output<String>? = null

    private var imageRecipeArn: Output<String>? = null

    private var imageScanningConfiguration: Output<ImageImageScanningConfigurationArgs>? = null

    private var imageTestsConfiguration: Output<ImageImageTestsConfigurationArgs>? = null

    private var infrastructureConfigurationArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workflows: Output<List<ImageWorkflowArgs>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("npntmiqgxrpdtyqt")
    public suspend fun containerRecipeArn(`value`: Output<String>) {
        this.containerRecipeArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("rriesfokbalhaaka")
    public suspend fun distributionConfigurationArn(`value`: Output<String>) {
        this.distributionConfigurationArn = value
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("tfggjpvlyqnqlbwq")
    public suspend fun enhancedImageMetadataEnabled(`value`: Output<Boolean>) {
        this.enhancedImageMetadataEnabled = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
     */
    @JvmName("hmsswfpybqscjajx")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("fbwmflpchgttaggc")
    public suspend fun imageRecipeArn(`value`: Output<String>) {
        this.imageRecipeArn = value
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("mohkkkvxbjnlexdl")
    public suspend fun imageScanningConfiguration(`value`: Output<ImageImageScanningConfigurationArgs>) {
        this.imageScanningConfiguration = value
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("sajmgpngoswskjsn")
    public suspend fun imageTestsConfiguration(`value`: Output<ImageImageTestsConfigurationArgs>) {
        this.imageTestsConfiguration = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     * The following arguments are optional:
     */
    @JvmName("lqeiouiwjhthruxt")
    public suspend fun infrastructureConfigurationArn(`value`: Output<String>) {
        this.infrastructureConfigurationArn = value
    }

    /**
     * @param value Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iacgklbmslkdayqi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("cjqoqjjsrhgvpcme")
    public suspend fun workflows(`value`: Output<List<ImageWorkflowArgs>>) {
        this.workflows = value
    }

    @JvmName("hnncxiskuhcbrcpk")
    public suspend fun workflows(vararg values: Output<ImageWorkflowArgs>) {
        this.workflows = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("tvvpyueotmssqmxk")
    public suspend fun workflows(values: List<Output<ImageWorkflowArgs>>) {
        this.workflows = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("qqpasgcabbbiuwta")
    public suspend fun containerRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRecipeArn = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("xmtoopkmlfhsalyq")
    public suspend fun distributionConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionConfigurationArn = mapped
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("smxonhwicvfhqhvx")
    public suspend fun enhancedImageMetadataEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedImageMetadataEnabled = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
     */
    @JvmName("ecmwsbpaqliritmn")
    public suspend fun executionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("hmpmyxmecgfpbsex")
    public suspend fun imageRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRecipeArn = mapped
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("kstqkhionbavkfdj")
    public suspend fun imageScanningConfiguration(`value`: ImageImageScanningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("gpqbpwxiucwdiyok")
    public suspend fun imageScanningConfiguration(argument: suspend ImageImageScanningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageImageScanningConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("opnrgjarnplismkk")
    public suspend fun imageTestsConfiguration(`value`: ImageImageTestsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("mqvsnxdnwtodliwy")
    public suspend fun imageTestsConfiguration(argument: suspend ImageImageTestsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageImageTestsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     * The following arguments are optional:
     */
    @JvmName("ysufxtrnvovxmxch")
    public suspend fun infrastructureConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfigurationArn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("egpdenfoobijeqik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fyfvynwfbrjuhaqq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("neuludnmlawrkitx")
    public suspend fun workflows(`value`: List<ImageWorkflowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("wrnjvugbolaoknot")
    public suspend fun workflows(argument: List<suspend ImageWorkflowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageWorkflowArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("hqvwrmrankbvtsei")
    public suspend fun workflows(vararg argument: suspend ImageWorkflowArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageWorkflowArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("wgdkjedvkkoyrvuo")
    public suspend fun workflows(argument: suspend ImageWorkflowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageWorkflowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param values Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("lfvtfescuioaejjc")
    public suspend fun workflows(vararg values: ImageWorkflowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflows = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        containerRecipeArn = containerRecipeArn,
        distributionConfigurationArn = distributionConfigurationArn,
        enhancedImageMetadataEnabled = enhancedImageMetadataEnabled,
        executionRole = executionRole,
        imageRecipeArn = imageRecipeArn,
        imageScanningConfiguration = imageScanningConfiguration,
        imageTestsConfiguration = imageTestsConfiguration,
        infrastructureConfigurationArn = infrastructureConfigurationArn,
        tags = tags,
        workflows = workflows,
    )
}
